/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.geotools.data.arcgis;

import java.io.IOException;
import nl.tailormap.geotools.data.arcgis.ArcGISDataStore;
import nl.tailormap.geotools.data.arcgis.ArcGISFeatureReader;
import nl.tailormap.geotools.data.arcgis.ArcGISUtils;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.sort.SortBy;

public class ArcGISFeatureSource
extends ContentFeatureSource {
    public static final String DEFAULT_GEOMETRY_ATTRIBUTE_NAME = "geometry";

    public ArcGISFeatureSource(ContentEntry ce) {
        super(ce, null);
    }

    public QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isJoiningSupported() {
                return false;
            }

            public boolean isOffsetSupported() {
                return true;
            }

            public boolean isReliableFIDSupported() {
                return true;
            }

            public boolean isVersionSupported() {
                return false;
            }

            public boolean supportsSorting(SortBy[] attributes) {
                return false;
            }
        };
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canOffset() {
        return true;
    }

    protected ArcGISDataStore getArcGISDataStore() {
        return (ArcGISDataStore)this.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected int getCountInternal(Query query) throws IOException {
        return new ArcGISFeatureReader(this, query).getCount();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new ArcGISFeatureReader(this, query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        JSONObject layer = this.getArcGISDataStore().getLayerJSON(this.entry.getTypeName());
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(this.entry.getTypeName());
        JSONArray fields = (JSONArray)layer.get((Object)"fields");
        for (Object o : fields) {
            JSONObject f = (JSONObject)o;
            Class binding = ArcGISUtils.getBinding((String)f.get((Object)"type"));
            if (binding.equals(Geometry.class)) {
                binding = ArcGISUtils.getGeometryBinding((String)layer.get((Object)"geometryType"));
                b.add((String)f.get((Object)"name"), binding, this.getArcGISDataStore().getCRS());
                continue;
            }
            b.add((String)f.get((Object)"name"), binding);
        }
        if (b.getDefaultGeometry() == null) {
            Class binding = ArcGISUtils.getGeometryBinding((String)layer.get((Object)"geometryType"));
            b.add(DEFAULT_GEOMETRY_ATTRIBUTE_NAME, binding, this.getArcGISDataStore().getCRS());
        }
        return b.buildFeatureType();
    }
}

