/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.solr;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class SolrInitializer
implements ServletContextListener {
    private static HttpSolrServer server;
    private static final Log log;
    private ServletContext context;
    private static final String SOLR_DIR = ".solr/";
    private static final String SOLR_CORE_NAME = "flamingo";
    public static final String DATA_DIR = "tailormap.data.dir";
    private final String SETUP_SOLR = "tailormap.solr.setup";
    private final String SOLR_URL = "tailormap.solr.url";
    private boolean setupSolr = false;
    private String datadirectory;
    private String solrUrl;
    private static final String SOLR_CONF_DIR = "/WEB-INF/classes/solr/flamingo";

    public void contextInitialized(ServletContextEvent sce) {
        log.debug((Object)"SolrInitializer initializing");
        this.context = sce.getServletContext();
        this.init();
        System.setProperty("solr.solr.home", this.datadirectory + File.separator + SOLR_DIR);
        File dataDirectory = new File(this.datadirectory);
        if (!this.isCorrectDir(dataDirectory)) {
            log.error((Object)("Cannot read/write data dir " + this.datadirectory + ". Solr searching not possible."));
            return;
        }
        log.info((Object)("Data dir set " + this.datadirectory));
        File solrDir = new File(dataDirectory, SOLR_DIR);
        if (this.setupSolr && !solrDir.exists()) {
            this.setupSolr(solrDir);
        }
        this.inializeSolr(solrDir);
    }

    private void setupSolr(File solrdir) {
        log.debug((Object)"Setup the solr directory");
        this.copyConf(solrdir);
    }

    private void inializeSolr(File solrDir) {
        log.debug((Object)"Initialize the Solr Server instance");
        if (this.solrUrl != null && this.solrUrl.length() < 1) {
            log.info((Object)"Skip initializing Solr Server instance, no url");
            return;
        }
        if (this.solrUrl.charAt(this.solrUrl.length() - 1) != '/') {
            this.solrUrl = this.solrUrl + "/";
        }
        server = new HttpSolrServer(this.solrUrl + SOLR_CORE_NAME);
        server.setFollowRedirects(true);
    }

    public static SolrServer getServerInstance() {
        return server;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (server != null) {
            server.shutdown();
            log.debug((Object)"SolrInitializer destroyed");
        }
    }

    private boolean isCorrectDir(File f) {
        return f.isDirectory() && f.canRead() && f.canWrite();
    }

    private void copyConf(File solrDir) {
        try {
            File conf = new File(this.context.getRealPath("/WEB-INF/classes/solr/solr.xml"));
            FileUtils.copyFile((File)conf, (File)new File(solrDir, "solr.xml"));
            File coreConfiguration = new File(this.context.getRealPath(SOLR_CONF_DIR));
            File coreDir = new File(solrDir, SOLR_CORE_NAME);
            FileUtils.copyDirectory((File)coreConfiguration, (File)coreDir);
        }
        catch (Exception ex) {
            log.error((Object)"Setup of the solr directory failed: ", (Throwable)ex);
        }
    }

    private void init() {
        String setupSolrParam = this.context.getInitParameter("tailormap.solr.setup");
        if (setupSolrParam != null) {
            this.setupSolr = Boolean.parseBoolean(setupSolrParam);
        }
        this.datadirectory = this.context.getInitParameter(DATA_DIR);
        this.solrUrl = this.context.getInitParameter("tailormap.solr.url");
    }

    static {
        log = LogFactory.getLog(SolrInitializer.class);
    }
}

