/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.util.UriUtils;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;

@Controller
public class FrontController {
    private static final AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    @Value(value="${spring.profiles.active:}")
    private String activeProfile;

    public FrontController(@Lazy ConfigurationRepository configurationRepository, @Lazy ApplicationRepository applicationRepository) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
    }

    @GetMapping(value={"/", "/login", "/app", "/app/", "/app/**", "/service/**", "/admin/**", "/ext/**"})
    public String appIndex(HttpServletRequest request) {
        String appLanguage;
        String path = request.getRequestURI().substring(request.getContextPath().length());
        Application app = null;
        if (!this.activeProfile.contains("static-only")) {
            String[] parts;
            if ("/".equals(path) || "/app".equals(path) || "/app/".equals(path)) {
                String defaultAppName = this.configurationRepository.get("default-app");
                app = this.applicationRepository.findByName(defaultAppName);
            } else if (path.startsWith("/app/") && (parts = path.split("/", -1)).length > 2) {
                String appName = UriUtils.decode((String)parts[2], (Charset)StandardCharsets.UTF_8);
                app = this.applicationRepository.findByName(appName);
            }
        }
        if (app != null && app.getSettings().getI18nSettings() != null && (appLanguage = app.getSettings().getI18nSettings().getDefaultLanguage()) != null && localeResolver.getSupportedLocales().stream().anyMatch(l -> l.toLanguageTag().equals(appLanguage))) {
            return "forward:/" + appLanguage + "/index.html";
        }
        Locale locale = localeResolver.resolveLocale(request);
        return "forward:/" + locale.toLanguageTag() + "/index.html";
    }

    @GetMapping(value={"/{locale}/", "/{locale}/login", "/{locale:^(?!api)[a-zA-Z-]+}/app/**", "/{locale:^(?!api)[a-zA-Z-]+}/service/**", "/{locale:^(?!api)[a-zA-Z-]+}/admin/**", "/{locale:^(?!api)[a-zA-Z-]+}/ext/**"})
    public String localePrefixedAppIndex(@PathVariable(value="locale") String locale, HttpServletRequest request) {
        if (localeResolver.getSupportedLocales().stream().anyMatch(l -> l.toLanguageTag().equals(locale))) {
            return "forward:/" + locale + "/index.html";
        }
        return this.appIndex(request);
    }

    @GetMapping(value={"/swagger-ui", "/swagger-ui/"})
    public String swaggerUiWelcomePage() {
        return "redirect:/swagger-ui/index.html";
    }

    static {
        localeResolver.setSupportedLocales(List.of(new Locale("en"), new Locale("nl"), new Locale("de")));
        localeResolver.setDefaultLocale((Locale)localeResolver.getSupportedLocales().get(0));
    }
}

