/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.tailormap.api.configuration.CaseInsensitiveEnumConverter;
import org.tailormap.api.configuration.base.IndexHtmlTransformer;
import org.tailormap.api.persistence.json.GeoServiceProtocol;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    @Value(value="${spring.web.resources.static-locations:file:/home/spring/static/}")
    private String resourceLocations;
    private final IndexHtmlTransformer indexHtmlTransformer;

    public WebMvcConfig(IndexHtmlTransformer indexHtmlTransformer) {
        this.indexHtmlTransformer = indexHtmlTransformer;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/*/index.html"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).setCacheControl(CacheControl.noCache()).resourceChain(true).addTransformer((ResourceTransformer)this.indexHtmlTransformer);
        registry.addResourceHandler(new String[]{"/version.json"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).setCacheControl(CacheControl.noStore());
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).resourceChain(true).addResolver((ResourceResolver)new EncodedResourceResolver());
    }

    public void addFormatters(@NonNull FormatterRegistry registry) {
        List.of(GeoServiceProtocol.class).forEach(enumClass -> registry.addConverter(String.class, enumClass, new CaseInsensitiveEnumConverter(enumClass)));
    }
}

