/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.geotools.TransformationUtil;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.geotools.processing.GeometryProcessor;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.TMAttributeTypeHelper;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.FeatureTypeTemplate;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.TMAttributeDescriptor;
import org.tailormap.api.persistence.json.TMAttributeType;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.util.Constants;
import org.tailormap.api.viewer.model.ColumnMetadata;
import org.tailormap.api.viewer.model.Feature;
import org.tailormap.api.viewer.model.FeaturesResponse;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/features"}, produces={"application/json"})
public class FeaturesController
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureSourceRepository featureSourceRepository;
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    @Value(value="${tailormap-api.pageSize:100}")
    private int pageSize;
    @Value(value="${tailormap-api.features.wfs_count_exact:false}")
    private boolean exactWfsCounts;

    public FeaturesController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureSourceRepository featureSourceRepository) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @Timed(value="get_features", description="time spent to process get features call")
    public ResponseEntity<Serializable> getFeatures(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @RequestParam(required=false) Double x, @RequestParam(required=false) Double y, @RequestParam(defaultValue="4") Double distance, @RequestParam(required=false) String __fid, @RequestParam(defaultValue="false") Boolean simplify, @RequestParam(required=false) String filter, @RequestParam(required=false) Integer page, @RequestParam(required=false) String sortBy, @RequestParam(required=false, defaultValue="asc") String sortOrder, @RequestParam(defaultValue="false") boolean onlyGeometries, @RequestParam(defaultValue="false") boolean geometryInAttributes) {
        FeaturesResponse featuresResponse;
        if (layer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Can't find layer " + appTreeLayerNode);
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (tmft == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Layer does not have feature type");
        }
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (onlyGeometries) {
            geometryInAttributes = true;
        }
        if (null != __fid) {
            featuresResponse = this.getFeatureByFID(tmft, appLayerSettings, __fid, application, !geometryInAttributes);
        } else if (null != x && null != y) {
            featuresResponse = this.getFeaturesByXY(tmft, appLayerSettings, filter, x, y, application, distance, simplify, !geometryInAttributes);
        } else if (null != page && page > 0) {
            featuresResponse = this.getAllFeatures(tmft, application, appLayerSettings, page, filter, sortBy, sortOrder, onlyGeometries, !geometryInAttributes);
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unsupported combination of request parameters");
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)featuresResponse);
    }

    @NotNull
    private FeaturesResponse getAllFeatures(@NotNull TMFeatureType tmft, @NotNull Application application, @NotNull AppLayerSettings appLayerSettings, Integer page, String filterCQL, String sortBy, String sortOrder, boolean onlyGeometries, boolean skipGeometryOutput) {
        FeaturesResponse featuresResponse = new FeaturesResponse().page(page).pageSize(this.pageSize);
        SimpleFeatureSource fs = null;
        try {
            int featureCount;
            String sortAttrName;
            fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmft);
            List<Object> propNames = TMFeatureTypeHelper.getConfiguredAttributes(tmft, appLayerSettings).values().stream().map(Pair::getLeft).filter(a -> !TMAttributeTypeHelper.isGeometry(a.getType())).map(TMAttributeDescriptor::getName).collect(Collectors.toList());
            if (onlyGeometries) {
                propNames = List.of(tmft.getDefaultGeometryAttribute());
                sortAttrName = null;
            } else {
                if (propNames.isEmpty()) {
                    FeaturesResponse featuresResponse2 = featuresResponse;
                    return featuresResponse2;
                }
                sortAttrName = tmft.getPrimaryKeyAttribute() != null && propNames.contains(tmft.getPrimaryKeyAttribute()) ? tmft.getPrimaryKeyAttribute() : (String)propNames.get(0);
                if (null != sortBy) {
                    if (propNames.contains(sortBy)) {
                        sortAttrName = sortBy;
                    } else {
                        logger.warn("Requested sortBy attribute {} was not found in configured attributes or is a geometry attribute", (Object)sortBy);
                    }
                }
            }
            SortOrder _sortOrder = SortOrder.ASCENDING;
            if (null != sortOrder && (sortOrder.equalsIgnoreCase("desc") || sortOrder.equalsIgnoreCase("asc"))) {
                _sortOrder = SortOrder.valueOf((String)sortOrder.toUpperCase(Locale.ROOT));
            }
            Query q = new Query(fs.getName().toString());
            q.setPropertyNames(propNames);
            if (null != filterCQL) {
                Filter filter = ECQL.toFilter((String)filterCQL);
                q.setFilter(filter);
                featureCount = fs.getCount(q);
                if (featureCount == -1 && this.exactWfsCounts) {
                    featureCount = fs.getFeatures(q).size();
                }
            } else {
                featureCount = fs.getCount(Query.ALL);
                if (featureCount == -1 && this.exactWfsCounts) {
                    featureCount = fs.getFeatures(Query.ALL).size();
                }
            }
            featuresResponse.setTotal(featureCount);
            if (sortAttrName != null) {
                q.setSortBy(new SortBy[]{this.ff.sort(sortAttrName, _sortOrder)});
            }
            q.setMaxFeatures(this.pageSize);
            q.setStartIndex(Integer.valueOf((page - 1) * this.pageSize));
            logger.debug("Attribute query: {}", (Object)q);
            this.executeQueryOnFeatureSourceAndClose(false, featuresResponse, tmft, appLayerSettings, onlyGeometries, fs, q, application, skipGeometryOutput);
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data.", (Throwable)e);
        }
        catch (CQLException e) {
            logger.error("Could not parse requested filter.", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Could not parse requested filter");
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        return featuresResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FeaturesResponse getFeatureByFID(@NotNull TMFeatureType tmFeatureType, @NotNull AppLayerSettings appLayerSettings, @NotNull String fid, @NotNull Application application, boolean skipGeometryOutput) {
        FeaturesResponse featuresResponse = new FeaturesResponse();
        SimpleFeatureSource fs = null;
        try {
            fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
            Query q = new Query(fs.getName().toString());
            q.setFilter((Filter)this.ff.id(new FeatureId[]{this.ff.featureId(fid)}));
            q.setMaxFeatures(1);
            logger.debug("FID query: {}", (Object)q);
            this.executeQueryOnFeatureSourceAndClose(false, featuresResponse, tmFeatureType, appLayerSettings, false, fs, q, application, skipGeometryOutput);
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data", (Throwable)e);
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        return featuresResponse;
    }

    @NotNull
    private FeaturesResponse getFeaturesByXY(@NotNull TMFeatureType tmFeatureType, @NotNull AppLayerSettings appLayerSettings, String filterCQL, @NotNull Double x, @NotNull Double y, @NotNull Application application, @NotNull Double distance, @NotNull Boolean simplifyGeometry, boolean skipGeometryOutput) {
        if (null != distance && 0.0 >= distance) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Buffer distance must be greater than 0");
        }
        FeaturesResponse featuresResponse = new FeaturesResponse();
        try {
            Intersects spatialFilter;
            GeometricShapeFactory shapeFact = new GeometricShapeFactory();
            shapeFact.setNumPoints(32);
            shapeFact.setCentre(new Coordinate(x.doubleValue(), y.doubleValue()));
            shapeFact.setSize(distance * 2.0);
            Polygon p = shapeFact.createCircle();
            logger.debug("created geometry: {}", (Object)p);
            MathTransform transform = null;
            SimpleFeatureSource fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
            try {
                transform = TransformationUtil.getTransformationToDataSource(application, fs);
            }
            catch (FactoryException e) {
                logger.warn("Unable to find transformation from query geometry to desired datasource", (Throwable)e);
            }
            if (null != transform) {
                try {
                    p = JTS.transform((Geometry)p, (MathTransform)transform);
                    logger.debug("reprojected geometry to: {}", (Object)p);
                }
                catch (TransformException e) {
                    logger.warn("Unable to transform query geometry to desired CRS, trying with original CRS");
                }
            }
            logger.debug("using selection geometry: {}", (Object)p);
            Intersects finalFilter = spatialFilter = this.ff.intersects((Expression)this.ff.property(tmFeatureType.getDefaultGeometryAttribute()), (Expression)this.ff.literal((Object)p));
            if (null != filterCQL) {
                Filter filter = ECQL.toFilter((String)filterCQL);
                finalFilter = this.ff.and((Filter)spatialFilter, filter);
            }
            Query q = new Query(fs.getName().toString());
            q.setFilter((Filter)finalFilter);
            q.setMaxFeatures(10);
            this.executeQueryOnFeatureSourceAndClose(simplifyGeometry, featuresResponse, tmFeatureType, appLayerSettings, false, fs, q, application, skipGeometryOutput);
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data", (Throwable)e);
        }
        catch (CQLException e) {
            logger.error("Could not parse requested filter.", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Could not parse requested filter");
        }
        return featuresResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryOnFeatureSourceAndClose(boolean simplifyGeometry, @NotNull FeaturesResponse featuresResponse, @NotNull TMFeatureType tmFeatureType, @NotNull AppLayerSettings appLayerSettings, boolean onlyGeometries, @NotNull SimpleFeatureSource featureSource, @NotNull Query selectQuery, @NotNull Application application, boolean skipGeometryOutput) throws IOException {
        boolean addFields = false;
        MathTransform transform = null;
        try {
            transform = TransformationUtil.getTransformationToApplication(application, featureSource);
        }
        catch (FactoryException e) {
            logger.error("Can not transform geometry to desired CRS", (Throwable)e);
        }
        Map<String, Pair<TMAttributeDescriptor, AttributeSettings>> configuredAttributes = TMFeatureTypeHelper.getConfiguredAttributes(tmFeatureType, appLayerSettings);
        try (SimpleFeatureIterator feats = featureSource.getFeatures(selectQuery).features();){
            while (feats.hasNext()) {
                addFields = true;
                SimpleFeature feature = (SimpleFeature)feats.next();
                String processedGeometry = GeometryProcessor.processGeometry(feature.getAttribute(tmFeatureType.getDefaultGeometryAttribute()), simplifyGeometry, true, transform);
                Feature newFeat = new Feature().fid(feature.getIdentifier().getID()).geometry(processedGeometry);
                if (!onlyGeometries) {
                    for (String attName : configuredAttributes.keySet()) {
                        Object value = feature.getAttribute(attName);
                        if (value instanceof Geometry) {
                            value = skipGeometryOutput ? null : GeometryProcessor.geometryToWKT((Geometry)value);
                        }
                        newFeat.putAttributesItem(attName, value);
                    }
                }
                featuresResponse.addFeaturesItem(newFeat);
            }
        }
        finally {
            featureSource.getDataStore().dispose();
        }
        FeatureTypeTemplate ftt = tmFeatureType.getSettings().getTemplate();
        if (ftt != null) {
            featuresResponse.setTemplate(ftt.getTemplate());
        }
        if (addFields) {
            configuredAttributes.values().stream().map(pair -> {
                TMAttributeDescriptor attributeDescriptor = (TMAttributeDescriptor)pair.getLeft();
                TMAttributeType type = attributeDescriptor.getType();
                AttributeSettings settings = (AttributeSettings)pair.getRight();
                return new ColumnMetadata().key(attributeDescriptor.getName()).alias(settings.getTitle()).type(TMAttributeTypeHelper.isGeometry(type) ? TMAttributeType.GEOMETRY : type);
            }).forEach(featuresResponse::addColumnMetadataItem);
        }
    }
}

