/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.geotools.wfs.SimpleWFSHelper;
import org.tailormap.api.geotools.wfs.SimpleWFSLayerDescription;
import org.tailormap.api.geotools.wfs.WFSProxy;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.util.HttpProxyUtil;
import org.tailormap.api.viewer.model.LayerExportCapabilities;

@AppRestController
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/export/"})
public class LayerExportController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceRepository featureSourceRepository;

    public LayerExportController(FeatureSourceRepository featureSourceRepository) {
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @GetMapping(path={"capabilities"})
    @Timed(value="export_get_capabilities", description="Get layer export capabilities")
    public ResponseEntity<Serializable> capabilities(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer) throws Exception {
        LayerExportCapabilities capabilities = new LayerExportCapabilities().exportable(false);
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        if (tmft != null) {
            WFSTypeNameDescriptor wfsTypeNameDescriptor = this.findWFSFeatureType(service, layer, tmft);
            if (wfsTypeNameDescriptor != null) {
                try {
                    List<String> outputFormats = SimpleWFSHelper.getOutputFormats(wfsTypeNameDescriptor.wfsUrl(), wfsTypeNameDescriptor.typeName(), wfsTypeNameDescriptor.username(), wfsTypeNameDescriptor.password());
                    capabilities.setOutputFormats(outputFormats);
                }
                catch (Exception e) {
                    String msg = String.format("Error getting capabilities for WFS \"%s\"", wfsTypeNameDescriptor.wfsUrl());
                    if (logger.isTraceEnabled()) {
                        logger.trace(msg, (Throwable)e);
                    } else {
                        logger.warn("{}: {}: {}", new Object[]{msg, e.getClass(), e.getMessage()});
                    }
                    capabilities.setOutputFormats(null);
                }
            }
            capabilities.setExportable(capabilities.getOutputFormats() != null && !capabilities.getOutputFormats().isEmpty());
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)capabilities);
    }

    @Transactional
    @RequestMapping(path={"download"}, method={RequestMethod.GET, RequestMethod.POST})
    @Counted(value="export_download", description="Count of layer downloads")
    public ResponseEntity<?> download(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application application, @ModelAttribute AppTreeLayerNode appTreeLayerNode, @RequestParam String outputFormat, @RequestParam(required=false) List<String> attributes, @RequestParam(required=false) String filter, @RequestParam(required=false) String sortBy, @RequestParam(required=false) String sortOrder, @RequestParam(required=false) String crs, HttpServletRequest request) throws Exception {
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (tmft == null) {
            logger.debug("Layer export requested for layer without feature type");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        WFSTypeNameDescriptor wfsTypeNameDescriptor = this.findWFSFeatureType(service, layer, tmft);
        if (wfsTypeNameDescriptor == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, "No suitable WFS available for layer export");
        }
        if (attributes == null) {
            attributes = new ArrayList<String>();
        }
        Set<String> nonHiddenAttributes = TMFeatureTypeHelper.getConfiguredAttributes(tmft, appLayerSettings).keySet();
        if (!attributes.isEmpty()) {
            if (!nonHiddenAttributes.containsAll(attributes)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "One or more requested attributes are not available on the feature type");
            }
        } else if (!tmft.getSettings().getHideAttributes().isEmpty()) {
            attributes = new ArrayList<String>(nonHiddenAttributes);
        }
        if (!attributes.isEmpty() && tmft.getDefaultGeometryAttribute() != null) {
            attributes.add(tmft.getDefaultGeometryAttribute());
        }
        try {
            List<String> wfsAttributeNames = LayerExportController.getWFSAttributeNames(wfsTypeNameDescriptor);
            attributes.retainAll(wfsAttributeNames);
        }
        catch (IOException e) {
            logger.error("Error getting WFS feature type", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Error getting WFS feature type");
        }
        return this.downloadFromWFS(wfsTypeNameDescriptor, outputFormat, attributes, filter, sortBy, sortOrder, crs, request);
    }

    private ResponseEntity<?> downloadFromWFS(WFSTypeNameDescriptor wfsTypeName, String outputFormat, List<String> attributes, String filter, String sortBy, String sortOrder, String crs, HttpServletRequest request) {
        LinkedMultiValueMap getFeatureParameters = new LinkedMultiValueMap();
        getFeatureParameters.add((Object)"typeNames", (Object)wfsTypeName.typeName());
        getFeatureParameters.add((Object)"outputFormat", (Object)outputFormat);
        if (filter != null) {
            getFeatureParameters.add((Object)"cql_filter", (Object)filter);
        }
        if (crs != null) {
            getFeatureParameters.add((Object)"srsName", (Object)crs);
        }
        if (!CollectionUtils.isEmpty(attributes)) {
            getFeatureParameters.add((Object)"propertyName", (Object)String.join((CharSequence)",", attributes));
        }
        if (sortBy != null) {
            getFeatureParameters.add((Object)"sortBy", (Object)(sortBy + ("asc".equals(sortOrder) ? " A" : " D")));
        }
        URI wfsGetFeature = SimpleWFSHelper.getWFSRequestURL(wfsTypeName.wfsUrl(), "GetFeature", (MultiValueMap<String, String>)getFeatureParameters);
        logger.info("Layer download, proxying WFS GetFeature request {}", (Object)wfsGetFeature);
        try {
            HttpResponse<InputStream> response = WFSProxy.proxyWfsRequest(wfsGetFeature, wfsTypeName.username(), wfsTypeName.password(), request);
            logger.info("Layer download response code: {}, content type: {}, disposition: {}", new Object[]{response.statusCode(), response.headers().firstValue("Content-Type").map(Object::toString).orElse("<none>"), response.headers().firstValue("Content-Disposition").map(Object::toString).orElse("<none>")});
            InputStreamResource body = new InputStreamResource(response.body());
            HttpHeaders headers = HttpProxyUtil.passthroughResponseHeaders(response.headers(), Set.of("Content-Type", "Content-Disposition"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.statusCode()).headers(headers)).body((Object)body);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).body((Object)"Bad Gateway");
        }
    }

    private WFSTypeNameDescriptor findWFSFeatureType(GeoService service, GeoServiceLayer layer, TMFeatureType tmft) {
        TMFeatureSource featureSource;
        String wfsUrl = null;
        String typeName = null;
        String username = null;
        String password = null;
        ServiceAuthentication auth = null;
        if (tmft != null && (featureSource = tmft.getFeatureSource()).getProtocol() == TMFeatureSource.Protocol.WFS) {
            wfsUrl = featureSource.getUrl();
            typeName = tmft.getName();
            auth = featureSource.getAuthentication();
        }
        if ((wfsUrl == null || typeName == null) && service.getProtocol() == GeoServiceProtocol.WMS) {
            auth = service.getAuthentication();
            SimpleWFSLayerDescription wfsLayerDescription = this.getWFSLayerDescriptionForWMS(service, layer.getName());
            if (wfsLayerDescription != null && wfsLayerDescription.getWfsUrl() != null && wfsLayerDescription.getFirstTypeName() != null) {
                wfsUrl = wfsLayerDescription.getWfsUrl();
                typeName = wfsLayerDescription.getFirstTypeName();
                auth = service.getAuthentication();
            }
        }
        if (auth != null && auth.getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            username = auth.getUsername();
            password = auth.getPassword();
        }
        if (wfsUrl != null && typeName != null) {
            return new WFSTypeNameDescriptor(wfsUrl, typeName, username, password);
        }
        return null;
    }

    private SimpleWFSLayerDescription getWFSLayerDescriptionForWMS(GeoService wmsService, String layerName) {
        SimpleWFSLayerDescription wfsLayerDescription;
        String username = null;
        String password = null;
        if (wmsService.getAuthentication() != null && wmsService.getAuthentication().getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            username = wmsService.getAuthentication().getUsername();
            password = wmsService.getAuthentication().getPassword();
        }
        if ((wfsLayerDescription = SimpleWFSHelper.describeWMSLayer(wmsService.getUrl(), username, password, layerName)) != null && wfsLayerDescription.getTypeNames().length > 0) {
            logger.info("WMS described layer \"{}\" with typeNames \"{}\" of WFS \"{}\" for WMS \"{}\"", new Object[]{layerName, Arrays.toString(wfsLayerDescription.getTypeNames()), wfsLayerDescription.getWfsUrl(), wmsService.getUrl()});
            return wfsLayerDescription;
        }
        return null;
    }

    private static List<String> getWFSAttributeNames(WFSTypeNameDescriptor wfsTypeNameDescriptor) throws IOException {
        HashMap<String, Object> connectionParameters = new HashMap<String, Object>();
        connectionParameters.put(WFSDataStoreFactory.URL.key, SimpleWFSHelper.getWFSRequestURL(wfsTypeNameDescriptor.wfsUrl(), "GetCapabilities").toURL());
        connectionParameters.put(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE);
        connectionParameters.put(WFSDataStoreFactory.WFS_STRATEGY.key, "geoserver");
        connectionParameters.put(WFSDataStoreFactory.LENIENT.key, Boolean.TRUE);
        connectionParameters.put(WFSDataStoreFactory.TIMEOUT.key, 5000);
        if (wfsTypeNameDescriptor.username() != null) {
            connectionParameters.put(WFSDataStoreFactory.USERNAME.key, wfsTypeNameDescriptor.username());
            connectionParameters.put(WFSDataStoreFactory.PASSWORD.key, wfsTypeNameDescriptor.password());
        }
        WFSDataStore wfs = new WFSDataStoreFactory().createDataStore(connectionParameters);
        List<String> attributeNames = wfs.getFeatureSource(wfsTypeNameDescriptor.typeName()).getSchema().getAttributeDescriptors().stream().map(AttributeDescriptor::getLocalName).toList();
        wfs.dispose();
        return attributeNames;
    }

    private record WFSTypeNameDescriptor(String wfsUrl, String typeName, String username, String password) {
    }
}

