/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoField;
import java.util.UUID;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.persistence.Upload;
import org.tailormap.api.repository.UploadRepository;

@RestController
@RequestMapping(path={"/api/uploads/{category}/{id}/{filename}"})
public class UploadsController {
    private final UploadRepository uploadRepository;

    public UploadsController(UploadRepository uploadRepository) {
        this.uploadRepository = uploadRepository;
    }

    @GetMapping
    public ResponseEntity<byte[]> getUpload(HttpServletRequest request, @PathVariable String category, @PathVariable(name="id") String idString, @PathVariable(required=false) String filename) {
        OffsetDateTime uploadLastModified;
        if (!idString.matches("(?i)^[\\da-f]{8}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{12}$")) {
            return ResponseEntity.badRequest().build();
        }
        UUID id = UUID.fromString(idString);
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince != -1L && ifModifiedSince >= (uploadLastModified = this.uploadRepository.findLastModifiedById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND))).with(ChronoField.MILLI_OF_SECOND, 0L).toInstant().toEpochMilli()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_MODIFIED).build();
        }
        Upload upload = this.uploadRepository.findWithContentByIdAndCategory(id, category).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{upload.getMimeType()})).lastModified(upload.getLastModified().toInstant())).contentLength((long)upload.getContentLength()).cacheControl(CacheControl.noCache().cachePublic())).body((Object)upload.getContent());
    }
}

