/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.util.Map;
import java.util.UUID;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.controller.UploadsController;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.helper.ApplicationHelper;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;
import org.tailormap.api.repository.UploadRepository;
import org.tailormap.api.security.AuthorizationService;
import org.tailormap.api.viewer.model.AppStyling;
import org.tailormap.api.viewer.model.MapResponse;
import org.tailormap.api.viewer.model.ViewerResponse;

@AppRestController
public class ViewerController {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final ApplicationHelper applicationHelper;
    private final AuthorizationService authorizationService;
    private final UploadRepository uploadRepository;

    public ViewerController(ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, ApplicationHelper applicationHelper, AuthorizationService authorizationService, UploadRepository uploadRepository) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.applicationHelper = applicationHelper;
        this.authorizationService = authorizationService;
        this.uploadRepository = uploadRepository;
    }

    @GetMapping(path={"${tailormap-api.base-path}/app"})
    @Timed(value="get_default_app", description="Get default app")
    @Counted(value="get_default_app", description="Count of get default app")
    public ViewerResponse defaultApp() {
        String defaultAppName = this.configurationRepository.get("default-app");
        Application app = this.applicationRepository.findByName(defaultAppName);
        if (app == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (!this.authorizationService.mayUserRead(app)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.viewer(app, ViewerResponse.KindEnum.APP);
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}", "${tailormap-api.base-path}/service/{viewerName}"})
    @Timed(value="get_named_app", description="Get named app")
    @Counted(value="get_named_app", description="Count of get named app")
    public ViewerResponse viewer(@ModelAttribute Application app, @ModelAttribute ViewerResponse.KindEnum viewerKind) {
        ViewerResponse viewerResponse = app.getViewerResponse().kind(viewerKind);
        AppStyling styling = viewerResponse.getStyling();
        if (styling != null && styling.getLogo() != null && styling.getLogo().matches("(?i)^[\\da-f]{8}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{12}$")) {
            this.uploadRepository.findByIdAndCategory(UUID.fromString(styling.getLogo()), "app-logo").ifPresentOrElse(logo -> styling.setLogo(WebMvcLinkBuilder.linkTo(UploadsController.class, Map.of("id", logo.getId().toString(), "category", logo.getCategory(), "filename", logo.getFilename())).toString()), () -> styling.setLogo(null));
        }
        return viewerResponse;
    }

    @GetMapping(path={"${tailormap-api.base-path}/app/{viewerName}/map", "${tailormap-api.base-path}/service/{viewerName}/map"})
    public MapResponse map(@ModelAttribute Application app) {
        MapResponse mapResponse = this.applicationHelper.toMapResponse(app);
        mapResponse.getAppLayers().stream().filter(l -> l.getLegendImageUrl() != null && l.getLegendImageUrl().matches("(?i)^[\\da-f]{8}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{4}-[\\da-f]{12}$")).forEach(l -> {
            String url = this.uploadRepository.findByIdAndCategory(UUID.fromString(l.getLegendImageUrl()), "legend").map((? super T upload) -> WebMvcLinkBuilder.linkTo(UploadsController.class, Map.of("id", l.getLegendImageUrl(), "category", "legend", "filename", upload.getFilename())).toString()).orElse(null);
            l.setLegendImageUrl(url);
        });
        return mapResponse;
    }
}

