/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.SseEventBus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.tailormap.api.admin.model.ServerSentEvent;

@RestController
public class ServerSentEventsAdminController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SseEventBus eventBus;
    private final ObjectMapper objectMapper;

    public ServerSentEventsAdminController(SseEventBus eventBus, ObjectMapper objectMapper) {
        this.eventBus = eventBus;
        this.objectMapper = objectMapper;
    }

    @GetMapping(path={"${tailormap-api.admin.base-path}/events/{clientId}"})
    public SseEmitter entityEvents(@PathVariable(value="clientId") String clientId) {
        logger.debug("New SSE client: {}, all clients: {}", (Object)clientId, (Object)this.eventBus.getAllClientIds());
        return this.eventBus.createSseEmitter(clientId, Long.valueOf(3600000L), new String[]{"message"});
    }

    @Scheduled(fixedRate=60000L)
    public void keepAlive() throws JsonProcessingException {
        this.eventBus.handleEvent(SseEvent.ofData((Object)this.objectMapper.writeValueAsString((Object)new ServerSentEvent().eventType(ServerSentEvent.EventTypeEnum.KEEP_ALIVE))));
    }
}

