/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.NoSuchElementException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.repository.FeatureTypeRepository;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.solr.SolrHelper;
import org.tailormap.api.solr.SolrService;
import org.tailormap.api.viewer.model.ErrorResponse;

@RestController
public class SolrAdminController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureTypeRepository featureTypeRepository;
    private final SearchIndexRepository searchIndexRepository;
    private final SolrService solrService;

    public SolrAdminController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureTypeRepository featureTypeRepository, SearchIndexRepository searchIndexRepository, SolrService solrService) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureTypeRepository = featureTypeRepository;
        this.searchIndexRepository = searchIndexRepository;
        this.solrService = solrService;
    }

    @Operation(summary="Ping Solr", description="Ping Solr to check if it is available")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Solr is available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"status\":\"OK\",\"timeElapsed\":1}"))}), @ApiResponse(responseCode="500", description="Solr is not available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @GetMapping(path={"${tailormap-api.admin.base-path}/index/ping"}, produces={"application/json"})
    public ResponseEntity<?> pingSolr() {
        ResponseEntity responseEntity;
        block8: {
            SolrClient solrClient = this.solrService.getSolrClientForSearching();
            try {
                SolrPingResponse ping = solrClient.ping();
                logger.info("Solr ping status {}", ping.getResponse().get("status"));
                responseEntity = ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().put("status", ping.getResponse().get("status").toString()).put("timeElapsed", ping.getElapsedTime()));
                if (solrClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (solrClient != null) {
                        try {
                            solrClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SolrServerException e) {
                    logger.error("Error pinging solr", e);
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
                }
            }
            solrClient.close();
        }
        return responseEntity;
    }

    @Operation(summary="Create or update a feature type index", description="Create or update a feature type index for a layer, will erase existing index if present")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Index create or update request accepted"), @ApiResponse(responseCode="404", description="Layer does not have feature type", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Layer does not have feature type\",\"code\":404}"))}), @ApiResponse(responseCode="404", description="Indexing WFS feature types is not supported", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Layer does not have valid feature type for indexing\",\"code\":400}"))}), @ApiResponse(responseCode="500", description="Error while indexing", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Transactional
    @Timed(value="index_feature_type", description="time spent to index feature type")
    @PutMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    public ResponseEntity<?> index(@PathVariable Long searchIndexId) {
        SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById(searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
        TMFeatureType indexingFT = (TMFeatureType)this.featureTypeRepository.findById(searchIndex.getFeatureTypeId()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Feature type not found"));
        if (TMFeatureSource.Protocol.WFS.equals((Object)indexingFT.getFeatureSource().getProtocol())) {
            searchIndex.setStatus(SearchIndex.Status.ERROR).setComment("WFS indexing not supported");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not have valid feature type for indexing");
        }
        boolean createNewIndex = null == searchIndex.getLastIndexed() || searchIndex.getStatus() == SearchIndex.Status.INITIAL;
        try (SolrClient solrClient = this.solrService.getSolrClientForIndexing();
             SolrHelper solrHelper = new SolrHelper(solrClient);){
            solrHelper.addFeatureTypeIndex(searchIndex, indexingFT, this.featureSourceFactoryHelper);
            this.searchIndexRepository.save(searchIndex);
        }
        catch (IOException | UnsupportedOperationException | SolrServerException | SolrException e) {
            logger.error("Error indexing", e);
            searchIndex.setStatus(SearchIndex.Status.ERROR);
            this.searchIndexRepository.save(searchIndex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        }
        if (createNewIndex) {
            logger.info("Created new index for search index {}", (Object)searchIndexId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        logger.info("Updated index for search index {}", (Object)searchIndexId);
        return ResponseEntity.accepted().build();
    }

    @Operation(summary="Clear index for a feature type", description="Clear index for the feature type")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Index cleared"), @ApiResponse(responseCode="404", description="Index not configured for feature type"), @ApiResponse(responseCode="500", description="Error while clearing index", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Timed(value="index_delete", description="time spent to delete an index of a feature type")
    @DeleteMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<?> clearIndex(@PathVariable Long searchIndexId) {
        try (SolrClient solrClient = this.solrService.getSolrClientForSearching();
             SolrHelper solrHelper = new SolrHelper(solrClient);){
            solrHelper.clearIndexForLayer(searchIndexId);
            SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById(searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
            searchIndex.setLastIndexed(null).setStatus(SearchIndex.Status.INITIAL).setComment("Index cleared");
            this.searchIndexRepository.save(searchIndex);
        }
        catch (IOException | NoSuchElementException | SolrServerException e) {
            logger.warn("Error clearing index", e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        }
        logger.info("Index cleared for index {}", (Object)searchIndexId);
        return ResponseEntity.noContent().build();
    }
}

