/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.geotools.featuresources;

import java.io.IOException;
import org.geotools.api.data.SimpleFeatureSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import org.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import org.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;

@Service
public class FeatureSourceFactoryHelper {
    @Value(value="${tailormap-api.timeout}")
    private int timeout;

    public SimpleFeatureSource openGeoToolsFeatureSource(TMFeatureType tmft) throws IOException {
        return this.openGeoToolsFeatureSource(tmft, this.timeout);
    }

    public SimpleFeatureSource openGeoToolsFeatureSource(TMFeatureType tmft, int timeout) throws IOException {
        FeatureSourceHelper sh = this.getHelper(tmft.getFeatureSource());
        return sh.openGeoToolsFeatureSource(tmft, timeout);
    }

    private FeatureSourceHelper getHelper(TMFeatureSource fs) {
        return switch (fs.getProtocol()) {
            case TMFeatureSource.Protocol.JDBC -> new JDBCFeatureSourceHelper();
            case TMFeatureSource.Protocol.WFS -> new WFSFeatureSourceHelper();
            default -> throw new IllegalArgumentException("Invalid protocol: " + fs.getProtocol());
        };
    }
}

