/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JDBCConnectionProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DbtypeEnum dbtype;
    private String database;
    private Integer port;
    private String host;
    private String schema;
    private Integer fetchSize;
    private String primaryKeyMetadataTable;
    private String geometryMetadataTable;
    @Valid
    private Map<String, String> additionalProperties = new HashMap<String, String>();

    public JDBCConnectionProperties dbtype(DbtypeEnum dbtype) {
        this.dbtype = dbtype;
        return this;
    }

    @Schema(name="dbtype", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="dbtype")
    public DbtypeEnum getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(DbtypeEnum dbtype) {
        this.dbtype = dbtype;
    }

    public JDBCConnectionProperties database(String database) {
        this.database = database;
        return this;
    }

    @Schema(name="database", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public JDBCConnectionProperties port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="port", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public JDBCConnectionProperties host(String host) {
        this.host = host;
        return this;
    }

    @Schema(name="host", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public JDBCConnectionProperties schema(String schema) {
        this.schema = schema;
        return this;
    }

    @Schema(name="schema", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public JDBCConnectionProperties fetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Schema(name="fetchSize", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fetchSize")
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public JDBCConnectionProperties primaryKeyMetadataTable(String primaryKeyMetadataTable) {
        this.primaryKeyMetadataTable = primaryKeyMetadataTable;
        return this;
    }

    @Schema(name="primaryKeyMetadataTable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="primaryKeyMetadataTable")
    public String getPrimaryKeyMetadataTable() {
        return this.primaryKeyMetadataTable;
    }

    public void setPrimaryKeyMetadataTable(String primaryKeyMetadataTable) {
        this.primaryKeyMetadataTable = primaryKeyMetadataTable;
    }

    public JDBCConnectionProperties geometryMetadataTable(String geometryMetadataTable) {
        this.geometryMetadataTable = geometryMetadataTable;
        return this;
    }

    @Schema(name="geometryMetadataTable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometryMetadataTable")
    public String getGeometryMetadataTable() {
        return this.geometryMetadataTable;
    }

    public void setGeometryMetadataTable(String geometryMetadataTable) {
        this.geometryMetadataTable = geometryMetadataTable;
    }

    public JDBCConnectionProperties additionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JDBCConnectionProperties putAdditionalPropertiesItem(String key, String additionalPropertiesItem) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, String>();
        }
        this.additionalProperties.put(key, additionalPropertiesItem);
        return this;
    }

    @Schema(name="additionalProperties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="additionalProperties")
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JDBCConnectionProperties jdBCConnectionProperties = (JDBCConnectionProperties)o;
        return Objects.equals((Object)this.dbtype, (Object)jdBCConnectionProperties.dbtype) && Objects.equals(this.database, jdBCConnectionProperties.database) && Objects.equals(this.port, jdBCConnectionProperties.port) && Objects.equals(this.host, jdBCConnectionProperties.host) && Objects.equals(this.schema, jdBCConnectionProperties.schema) && Objects.equals(this.fetchSize, jdBCConnectionProperties.fetchSize) && Objects.equals(this.primaryKeyMetadataTable, jdBCConnectionProperties.primaryKeyMetadataTable) && Objects.equals(this.geometryMetadataTable, jdBCConnectionProperties.geometryMetadataTable) && Objects.equals(this.additionalProperties, jdBCConnectionProperties.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dbtype, this.database, this.port, this.host, this.schema, this.fetchSize, this.primaryKeyMetadataTable, this.geometryMetadataTable, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JDBCConnectionProperties {\n");
        sb.append("    dbtype: ").append(this.toIndentedString((Object)this.dbtype)).append("\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    fetchSize: ").append(this.toIndentedString(this.fetchSize)).append("\n");
        sb.append("    primaryKeyMetadataTable: ").append(this.toIndentedString(this.primaryKeyMetadataTable)).append("\n");
        sb.append("    geometryMetadataTable: ").append(this.toIndentedString(this.geometryMetadataTable)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DbtypeEnum {
        POSTGIS("postgis"),
        ORACLE("oracle"),
        SQLSERVER("sqlserver");

        private String value;

        private DbtypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DbtypeEnum fromValue(String value) {
            for (DbtypeEnum b : DbtypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

