/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.tailormap.api.persistence.User;
import org.tailormap.api.repository.UserRepository;
import org.tailormap.api.security.TailormapUserDetails;

@Service
public class TailormapUserDetailsService
implements UserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final UserRepository userRepository;

    public TailormapUserDetailsService(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userRepository.findById(username).orElse(null);
        if (user == null) {
            throw new UsernameNotFoundException("User " + username + " not found");
        }
        logger.trace("Found user: " + user.getUsername() + ", password " + user.getPassword());
        return new TailormapUserDetails(user);
    }
}

