/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.solr;

import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateHttp2SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SolrService {
    @Value(value="${tailormap-api.solr-url}")
    private String solrUrl;
    @Value(value="${tailormap-api.solr-core-name:tailormap}")
    private String solrCoreName;

    public SolrClient getSolrClientForIndexing() {
        return new ConcurrentUpdateHttp2SolrClient.Builder(this.solrUrl + this.solrCoreName, ((Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder().withFollowRedirects(true)).withConnectionTimeout(10000L, TimeUnit.MILLISECONDS)).withRequestTimeout(60000L, TimeUnit.MILLISECONDS)).build()).withQueueSize(2000).withThreadCount(10).build();
    }

    public SolrClient getSolrClientForSearching() {
        return ((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder(this.solrUrl + this.solrCoreName).withConnectionTimeout(10L, TimeUnit.SECONDS)).withFollowRedirects(true)).build();
    }

    public void setSolrUrl(String solrUrl) {
        this.solrUrl = solrUrl;
    }
}

