/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(name="Feature", description=" A possibly complete feature from the attribute source. The feature could have been filtered to not provide certain attributes. Any geometry attributes will be presented in WKT format ")
public class Feature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fid;
    private String geometry;
    @Valid
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public Feature fid(String fid) {
        this.fid = fid;
        return this;
    }

    @Schema(name="__fid", accessMode=Schema.AccessMode.READ_ONLY, description="feature id, a non-mutable identifier from the attribute source", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="__fid")
    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Feature geometry(String geometry) {
        this.geometry = geometry;
        return this;
    }

    @Schema(name="geometry", description=" Default geometry of the feature as WKT, possibly simplified. Always linearized to make sure that it only holds a specification valid WKT. Can be used for highlighting or buffer/selection, not for editing. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometry")
    public String getGeometry() {
        return this.geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public Feature attributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Feature putAttributesItem(String key, Object attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @NotNull
    @Schema(name="attributes", description="feature attributes in key/value pairs", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="attributes")
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.fid, feature.fid) && Objects.equals(this.geometry, feature.geometry) && Objects.equals(this.attributes, feature.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.fid, this.geometry, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Feature {\n");
        sb.append("    fid: ").append(this.toIndentedString(this.fid)).append("\n");
        sb.append("    geometry: ").append(this.toIndentedString(this.geometry)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

