/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.controller.PageController;
import org.tailormap.api.persistence.Configuration;
import org.tailormap.api.persistence.Page;
import org.tailormap.api.persistence.helper.UploadHelper;
import org.tailormap.api.persistence.json.MenuItem;
import org.tailormap.api.persistence.json.PageTile;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;
import org.tailormap.api.repository.PageRepository;
import org.tailormap.api.security.AuthorizationService;
import org.tailormap.api.viewer.model.PageResponse;
import org.tailormap.api.viewer.model.ViewerMenuItem;
import org.tailormap.api.viewer.model.ViewerPageTile;

@AppRestController
public class PageController {
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    private final AuthorizationService authorizationService;
    private final PageRepository pageRepository;
    private final UploadHelper uploadHelper;

    public PageController(ConfigurationRepository configurationRepository, ApplicationRepository applicationRepository, AuthorizationService authorizationService, PageRepository pageRepository, UploadHelper uploadHelper) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
        this.pageRepository = pageRepository;
        this.authorizationService = authorizationService;
        this.uploadHelper = uploadHelper;
    }

    private ResponseStatusException notFound() {
        return new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(path={"${tailormap-api.base-path}/page"})
    public PageResponse homePage() {
        Page page = (Page)this.configurationRepository.findByKey("home-page").map(Configuration::getValue).map(Long::parseLong).flatMap(arg_0 -> ((PageRepository)this.pageRepository).findById(arg_0)).orElseThrow(() -> this.notFound());
        return this.getPageResponse(page);
    }

    @GetMapping(path={"${tailormap-api.base-path}/page/{name}"})
    public PageResponse page(@PathVariable(required=false) String name) {
        return this.pageRepository.findByName(name).map(arg_0 -> this.getPageResponse(arg_0)).orElseThrow(() -> this.notFound());
    }

    private PageResponse getPageResponse(Page page) {
        PageResponse pageResponse = new PageResponse();
        BeanUtils.copyProperties((Object)page, (Object)pageResponse);
        pageResponse.tiles(page.getTiles().stream().map(arg_0 -> this.convert(arg_0)).filter(viewerPageTileResult -> !viewerPageTileResult.shouldBeFiltered).map(viewerPageTileResult -> viewerPageTileResult.viewerPageTile).toList());
        List menuItems = this.configurationRepository.findByKey("portal-menu").map(Configuration::getJsonValue).filter(JsonNode::isArray).map(jsonNode -> {
            try {
                return Arrays.asList((MenuItem[])new ObjectMapper().treeToValue((TreeNode)jsonNode, MenuItem[].class));
            }
            catch (IOException e) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, null, (Throwable)e);
            }
        }).orElse(Collections.emptyList());
        List<ViewerMenuItem> viewerMenuItems = menuItems.stream().filter(menuItem -> menuItem.getExclusiveOnPageId() == null || menuItem.getExclusiveOnPageId().equals(page.getId())).map(menuItem -> {
            ViewerMenuItem viewerMenuItem = new ViewerMenuItem();
            BeanUtils.copyProperties((Object)menuItem, (Object)viewerMenuItem);
            Optional.ofNullable(menuItem.getPageId()).flatMap(arg_0 -> ((PageRepository)this.pageRepository).findById(arg_0)).ifPresent(linkedPage -> viewerMenuItem.pageUrl("/page/" + linkedPage.getName()));
            return viewerMenuItem;
        }).toList();
        pageResponse.setMenu(viewerMenuItems);
        return pageResponse;
    }

    private ViewerPageTileResult convert(PageTile tile) {
        ViewerPageTile viewerPageTile = new ViewerPageTile();
        ViewerPageTileResult result = new ViewerPageTileResult();
        result.viewerPageTile = viewerPageTile;
        result.shouldBeFiltered = false;
        BeanUtils.copyProperties((Object)tile, (Object)viewerPageTile);
        if (tile.getApplicationId() != null) {
            Optional.ofNullable(tile.getApplicationId()).flatMap(arg_0 -> ((ApplicationRepository)this.applicationRepository).findById(arg_0)).filter(application -> !Boolean.TRUE.equals(tile.getFilterRequireAuthorization()) || this.authorizationService.userMayView(application)).ifPresentOrElse(application -> {
                viewerPageTile.applicationUrl("/app/" + application.getName());
                viewerPageTile.setApplicationRequiresLogin(Boolean.valueOf(!this.authorizationService.userMayView(application)));
            }, () -> {
                result.shouldBeFiltered = true;
            });
        }
        Optional.ofNullable(tile.getPageId()).flatMap(arg_0 -> ((PageRepository)this.pageRepository).findById(arg_0)).ifPresent(linkedPage -> viewerPageTile.pageUrl("/page/" + linkedPage.getName()));
        viewerPageTile.image(this.uploadHelper.getUrlForImage(tile.getImage(), "portal-image"));
        return result;
    }
}

