/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository.validation;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.repository.FeatureTypeRepository;

@Component
public class SearchIndexValidator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureTypeRepository featureTypeRepository;

    public SearchIndexValidator(FeatureTypeRepository featureTypeRepository) {
        this.featureTypeRepository = featureTypeRepository;
    }

    public boolean supports(@NonNull Class<?> clazz) {
        return SearchIndex.class.isAssignableFrom(clazz);
    }

    public void validate(@NonNull Object target, @NonNull Errors errors) {
        SearchIndex searchIndex = (SearchIndex)target;
        if (searchIndex.getFeatureTypeId() != null) {
            this.featureTypeRepository.findById((Object)searchIndex.getFeatureTypeId()).ifPresent(ft -> {
                if (TMFeatureSource.Protocol.WFS.equals((Object)ft.getFeatureSource().getProtocol())) {
                    logger.warn("Attempt to index feature type '{}' from unsupported WFS source '{}'.", (Object)ft.getName(), (Object)ft.getFeatureSource().getTitle());
                    errors.rejectValue("featureTypeId", "invalid", "This feature type is not available for indexing.");
                }
            });
        }
    }
}

