/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.AuthorizationRuleDecision;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;

@Service
public class AuthorizationService {
    public static final String ACCESS_TYPE_READ = "read";

    private Optional<AuthorizationRuleDecision> isAuthorizedByRules(List<AuthorizationRule> rules, String type) {
        Set<String> groups;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null || auth instanceof AnonymousAuthenticationToken) {
            groups = Set.of("anonymous");
        } else {
            groups = new HashSet<String>();
            groups.add("anonymous");
            groups.add("authenticated");
            for (GrantedAuthority authority : auth.getAuthorities()) {
                groups.add(authority.getAuthority());
            }
        }
        if (groups.contains("admin")) {
            return Optional.of(AuthorizationRuleDecision.ALLOW);
        }
        boolean hasValidRule = false;
        for (AuthorizationRule rule : rules) {
            boolean matchesGroup = groups.contains(rule.getGroupName());
            if (!matchesGroup) continue;
            hasValidRule = true;
            AuthorizationRuleDecision value = (AuthorizationRuleDecision)rule.getDecisions().get(type);
            if (value == null) {
                return Optional.empty();
            }
            if (!value.equals((Object)AuthorizationRuleDecision.ALLOW)) continue;
            return Optional.of(value);
        }
        if (hasValidRule) {
            return Optional.of(AuthorizationRuleDecision.DENY);
        }
        return Optional.empty();
    }

    public boolean userMayView(Application application) {
        return this.isAuthorizedByRules(application.getAuthorizationRules(), ACCESS_TYPE_READ).equals(Optional.of(AuthorizationRuleDecision.ALLOW));
    }

    public boolean userMayView(GeoService geoService) {
        return this.isAuthorizedByRules(geoService.getAuthorizationRules(), ACCESS_TYPE_READ).equals(Optional.of(AuthorizationRuleDecision.ALLOW));
    }

    public boolean userMayView(GeoService geoService, GeoServiceLayer layer) {
        Optional decision;
        Optional geoserviceDecision = this.isAuthorizedByRules(geoService.getAuthorizationRules(), ACCESS_TYPE_READ);
        if (geoserviceDecision.equals(Optional.of(AuthorizationRuleDecision.DENY))) {
            return false;
        }
        GeoServiceLayerSettings settings = (GeoServiceLayerSettings)geoService.getSettings().getLayerSettings().get(layer.getName());
        if (settings != null && settings.getAuthorizationRules() != null && ((decision = this.isAuthorizedByRules(settings.getAuthorizationRules(), ACCESS_TYPE_READ)).isPresent() || !settings.getAuthorizationRules().isEmpty())) {
            return decision.equals(Optional.of(AuthorizationRuleDecision.ALLOW));
        }
        return geoserviceDecision.equals(Optional.of(AuthorizationRuleDecision.ALLOW));
    }

    public boolean mustDenyAccessForSecuredProxy(Application application, GeoService geoService) {
        if (!Boolean.TRUE.equals(geoService.getSettings().getUseProxy())) {
            return false;
        }
        if (geoService.getAuthentication() == null) {
            return false;
        }
        return application.getAuthorizationRules().stream().anyMatch(rule -> "anonymous".equals(rule.getGroupName()) && AuthorizationRuleDecision.ALLOW.equals(rule.getDecisions().get(ACCESS_TYPE_READ)));
    }
}

