package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.Filter;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A group of filters. The group can be used to group filters together, or to disable a group of filters.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "FilterGroup", description = "A group of filters. The group can be used to group filters together, or to disable a group of filters.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class FilterGroup implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String source;

  @Valid
  private List<String> layerIds = new ArrayList<>();

  /**
   * NOTE spatial is not supported (for now) for preconfigured filters
   */
  public enum TypeEnum {
    ATTRIBUTE("ATTRIBUTE");

    private final String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private TypeEnum type;

  /**
   * The operator for the filter group, we may want to support the OR operator in the future
   */
  public enum OperatorEnum {
    AND("AND"),
    
    OR("OR");

    private final String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private OperatorEnum operator = OperatorEnum.AND;

  @Valid
  private List<@Valid Filter> filters = new ArrayList<>();

  private Boolean disabled = null;

  private String parentGroup = null;

  public FilterGroup id(String id) {
    this.id = id;
    return this;
  }

  /**
   * id of the filter group
   * @return id
   */
  
  @Schema(name = "id", description = "id of the filter group", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FilterGroup source(String source) {
    this.source = source;
    return this;
  }

  /**
   * source of the filter group
   * @return source
   */
  
  @Schema(name = "source", description = "source of the filter group", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("source")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public FilterGroup layerIds(List<String> layerIds) {
    this.layerIds = layerIds;
    return this;
  }

  public FilterGroup addLayerIdsItem(String layerIdsItem) {
    if (this.layerIds == null) {
      this.layerIds = new ArrayList<>();
    }
    this.layerIds.add(layerIdsItem);
    return this;
  }

  /**
   * list of layer ids
   * @return layerIds
   */
  @Size(min = 1) 
  @Schema(name = "layerIds", description = "list of layer ids", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("layerIds")
  public List<String> getLayerIds() {
    return layerIds;
  }

  public void setLayerIds(List<String> layerIds) {
    this.layerIds = layerIds;
  }

  public FilterGroup type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * NOTE spatial is not supported (for now) for preconfigured filters
   * @return type
   */
  
  @Schema(name = "type", description = "NOTE spatial is not supported (for now) for preconfigured filters", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public FilterGroup operator(OperatorEnum operator) {
    this.operator = operator;
    return this;
  }

  /**
   * The operator for the filter group, we may want to support the OR operator in the future
   * @return operator
   */
  
  @Schema(name = "operator", description = "The operator for the filter group, we may want to support the OR operator in the future", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operator")
  public OperatorEnum getOperator() {
    return operator;
  }

  public void setOperator(OperatorEnum operator) {
    this.operator = operator;
  }

  public FilterGroup filters(List<@Valid Filter> filters) {
    this.filters = filters;
    return this;
  }

  public FilterGroup addFiltersItem(Filter filtersItem) {
    if (this.filters == null) {
      this.filters = new ArrayList<>();
    }
    this.filters.add(filtersItem);
    return this;
  }

  /**
   * A list of filters
   * @return filters
   */
  @Valid @Size(min = 1) 
  @Schema(name = "filters", description = "A list of filters", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filters")
  public List<@Valid Filter> getFilters() {
    return filters;
  }

  public void setFilters(List<@Valid Filter> filters) {
    this.filters = filters;
  }

  public FilterGroup disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Get disabled
   * @return disabled
   */
  
  @Schema(name = "disabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("disabled")
  public Boolean getDisabled() {
    return disabled;
  }

  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  public FilterGroup parentGroup(String parentGroup) {
    this.parentGroup = parentGroup;
    return this;
  }

  /**
   * Get parentGroup
   * @return parentGroup
   */
  
  @Schema(name = "parentGroup", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parentGroup")
  public String getParentGroup() {
    return parentGroup;
  }

  public void setParentGroup(String parentGroup) {
    this.parentGroup = parentGroup;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterGroup filterGroup = (FilterGroup) o;
    return Objects.equals(this.id, filterGroup.id) &&
        Objects.equals(this.source, filterGroup.source) &&
        Objects.equals(this.layerIds, filterGroup.layerIds) &&
        Objects.equals(this.type, filterGroup.type) &&
        Objects.equals(this.operator, filterGroup.operator) &&
        Objects.equals(this.filters, filterGroup.filters) &&
        Objects.equals(this.disabled, filterGroup.disabled) &&
        Objects.equals(this.parentGroup, filterGroup.parentGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, source, layerIds, type, operator, filters, disabled, parentGroup);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterGroup {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    layerIds: ").append(toIndentedString(layerIds)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    parentGroup: ").append(toIndentedString(parentGroup)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

