package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.WMSStyle;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Layer of a service which can be an OGC WMS/WMTS service or from XYZ/ArcGIS REST.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "GeoServiceLayer", description = "Layer of a service which can be an OGC WMS/WMTS service or from XYZ/ArcGIS REST.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class GeoServiceLayer implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String name;

  private Boolean root;

  private String title;

  private Boolean virtual;

  private Double maxScale;

  private Double minScale;

  @Valid
  private Set<String> crs = new LinkedHashSet<>();

  private Bounds latLonBoundingBox;

  @Valid
  private List<@Valid WMSStyle> styles = new ArrayList<>();

  private Boolean queryable;

  private String abstractText;

  @Valid
  private List<String> children = new ArrayList<>();

  public GeoServiceLayer() {
    super();
  }

  public GeoServiceLayer id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique id assigned by TM, not from the capabilities. Assigned to make a tree with virtual layers. When referring to a non-virtual layer the name should always be used.
   * @return id
   */
  @NotNull 
  @Schema(name = "id", description = "Unique id assigned by TM, not from the capabilities. Assigned to make a tree with virtual layers. When referring to a non-virtual layer the name should always be used.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public GeoServiceLayer name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @NotNull 
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public GeoServiceLayer root(Boolean root) {
    this.root = root;
    return this;
  }

  /**
   * Get root
   * @return root
   */
  @NotNull 
  @Schema(name = "root", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("root")
  public Boolean getRoot() {
    return root;
  }

  public void setRoot(Boolean root) {
    this.root = root;
  }

  public GeoServiceLayer title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
   */
  
  @Schema(name = "title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public GeoServiceLayer virtual(Boolean virtual) {
    this.virtual = virtual;
    return this;
  }

  /**
   * A virtual layer has no name and can't be used in GetMap requests and is only used for tree structure.
   * @return virtual
   */
  @NotNull 
  @Schema(name = "virtual", description = "A virtual layer has no name and can't be used in GetMap requests and is only used for tree structure.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("virtual")
  public Boolean getVirtual() {
    return virtual;
  }

  public void setVirtual(Boolean virtual) {
    this.virtual = virtual;
  }

  public GeoServiceLayer maxScale(Double maxScale) {
    this.maxScale = maxScale;
    return this;
  }

  /**
   * Get maxScale
   * @return maxScale
   */
  
  @Schema(name = "maxScale", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxScale")
  public Double getMaxScale() {
    return maxScale;
  }

  public void setMaxScale(Double maxScale) {
    this.maxScale = maxScale;
  }

  public GeoServiceLayer minScale(Double minScale) {
    this.minScale = minScale;
    return this;
  }

  /**
   * Get minScale
   * @return minScale
   */
  
  @Schema(name = "minScale", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minScale")
  public Double getMinScale() {
    return minScale;
  }

  public void setMinScale(Double minScale) {
    this.minScale = minScale;
  }

  public GeoServiceLayer crs(Set<String> crs) {
    this.crs = crs;
    return this;
  }

  public GeoServiceLayer addCrsItem(String crsItem) {
    if (this.crs == null) {
      this.crs = new LinkedHashSet<>();
    }
    this.crs.add(crsItem);
    return this;
  }

  /**
   * Only the CRSes added by this layer, all parent CRSes are inherited.
   * @return crs
   */
  
  @Schema(name = "crs", description = "Only the CRSes added by this layer, all parent CRSes are inherited.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("crs")
  public Set<String> getCrs() {
    return crs;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setCrs(Set<String> crs) {
    this.crs = crs;
  }

  public GeoServiceLayer latLonBoundingBox(Bounds latLonBoundingBox) {
    this.latLonBoundingBox = latLonBoundingBox;
    return this;
  }

  /**
   * Get latLonBoundingBox
   * @return latLonBoundingBox
   */
  @Valid 
  @Schema(name = "latLonBoundingBox", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("latLonBoundingBox")
  public Bounds getLatLonBoundingBox() {
    return latLonBoundingBox;
  }

  public void setLatLonBoundingBox(Bounds latLonBoundingBox) {
    this.latLonBoundingBox = latLonBoundingBox;
  }

  public GeoServiceLayer styles(List<@Valid WMSStyle> styles) {
    this.styles = styles;
    return this;
  }

  public GeoServiceLayer addStylesItem(WMSStyle stylesItem) {
    if (this.styles == null) {
      this.styles = new ArrayList<>();
    }
    this.styles.add(stylesItem);
    return this;
  }

  /**
   * Get styles
   * @return styles
   */
  @Valid 
  @Schema(name = "styles", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("styles")
  public List<@Valid WMSStyle> getStyles() {
    return styles;
  }

  public void setStyles(List<@Valid WMSStyle> styles) {
    this.styles = styles;
  }

  public GeoServiceLayer queryable(Boolean queryable) {
    this.queryable = queryable;
    return this;
  }

  /**
   * Get queryable
   * @return queryable
   */
  
  @Schema(name = "queryable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("queryable")
  public Boolean getQueryable() {
    return queryable;
  }

  public void setQueryable(Boolean queryable) {
    this.queryable = queryable;
  }

  public GeoServiceLayer abstractText(String abstractText) {
    this.abstractText = abstractText;
    return this;
  }

  /**
   * Get abstractText
   * @return abstractText
   */
  
  @Schema(name = "abstractText", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("abstractText")
  public String getAbstractText() {
    return abstractText;
  }

  public void setAbstractText(String abstractText) {
    this.abstractText = abstractText;
  }

  public GeoServiceLayer children(List<String> children) {
    this.children = children;
    return this;
  }

  public GeoServiceLayer addChildrenItem(String childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

  /**
   * Get children
   * @return children
   */
  @NotNull 
  @Schema(name = "children", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("children")
  public List<String> getChildren() {
    return children;
  }

  public void setChildren(List<String> children) {
    this.children = children;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoServiceLayer geoServiceLayer = (GeoServiceLayer) o;
    return Objects.equals(this.id, geoServiceLayer.id) &&
        Objects.equals(this.name, geoServiceLayer.name) &&
        Objects.equals(this.root, geoServiceLayer.root) &&
        Objects.equals(this.title, geoServiceLayer.title) &&
        Objects.equals(this.virtual, geoServiceLayer.virtual) &&
        Objects.equals(this.maxScale, geoServiceLayer.maxScale) &&
        Objects.equals(this.minScale, geoServiceLayer.minScale) &&
        Objects.equals(this.crs, geoServiceLayer.crs) &&
        Objects.equals(this.latLonBoundingBox, geoServiceLayer.latLonBoundingBox) &&
        Objects.equals(this.styles, geoServiceLayer.styles) &&
        Objects.equals(this.queryable, geoServiceLayer.queryable) &&
        Objects.equals(this.abstractText, geoServiceLayer.abstractText) &&
        Objects.equals(this.children, geoServiceLayer.children);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, root, title, virtual, maxScale, minScale, crs, latLonBoundingBox, styles, queryable, abstractText, children);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoServiceLayer {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    root: ").append(toIndentedString(root)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    virtual: ").append(toIndentedString(virtual)).append("\n");
    sb.append("    maxScale: ").append(toIndentedString(maxScale)).append("\n");
    sb.append("    minScale: ").append(toIndentedString(minScale)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    latLonBoundingBox: ").append(toIndentedString(latLonBoundingBox)).append("\n");
    sb.append("    styles: ").append(toIndentedString(styles)).append("\n");
    sb.append("    queryable: ").append(toIndentedString(queryable)).append("\n");
    sb.append("    abstractText: ").append(toIndentedString(abstractText)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

