package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.TMAttributeType;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TMAttributeDescriptor
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class TMAttributeDescriptor implements Serializable {

  private static final long serialVersionUID = 1L;

  private String name;

  private String comment;

  private TMAttributeType type;

  private String unknownTypeClassName;

  private Boolean nullable;

  private String description;

  private String defaultValue = null;

  public TMAttributeDescriptor name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TMAttributeDescriptor comment(String comment) {
    this.comment = comment;
    return this;
  }

  /**
   * Comment from the source, if available (such as database comment) [TODO]
   * @return comment
   */
  
  @Schema(name = "comment", description = "Comment from the source, if available (such as database comment) [TODO]", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("comment")
  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public TMAttributeDescriptor type(TMAttributeType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @Valid 
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TMAttributeType getType() {
    return type;
  }

  public void setType(TMAttributeType type) {
    this.type = type;
  }

  public TMAttributeDescriptor unknownTypeClassName(String unknownTypeClassName) {
    this.unknownTypeClassName = unknownTypeClassName;
    return this;
  }

  /**
   * Class name of type (as produced by GeoTools DataStore) which isn't in the type enum list and thus unknown. When the type is 'object' this should contain the full class-name, mostly for debugging purposes so the type may be added to the enum list.
   * @return unknownTypeClassName
   */
  
  @Schema(name = "unknownTypeClassName", description = "Class name of type (as produced by GeoTools DataStore) which isn't in the type enum list and thus unknown. When the type is 'object' this should contain the full class-name, mostly for debugging purposes so the type may be added to the enum list.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("unknownTypeClassName")
  public String getUnknownTypeClassName() {
    return unknownTypeClassName;
  }

  public void setUnknownTypeClassName(String unknownTypeClassName) {
    this.unknownTypeClassName = unknownTypeClassName;
  }

  public TMAttributeDescriptor nullable(Boolean nullable) {
    this.nullable = nullable;
    return this;
  }

  /**
   * Get nullable
   * @return nullable
   */
  
  @Schema(name = "nullable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("nullable")
  public Boolean getNullable() {
    return nullable;
  }

  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }

  public TMAttributeDescriptor description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TMAttributeDescriptor defaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Default value for this attribute. It can be coerced to the type of the attribute using the `type` field.
   * @return defaultValue
   */
  
  @Schema(name = "defaultValue", description = "Default value for this attribute. It can be coerced to the type of the attribute using the `type` field.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultValue")
  public String getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMAttributeDescriptor tmAttributeDescriptor = (TMAttributeDescriptor) o;
    return Objects.equals(this.name, tmAttributeDescriptor.name) &&
        Objects.equals(this.comment, tmAttributeDescriptor.comment) &&
        Objects.equals(this.type, tmAttributeDescriptor.type) &&
        Objects.equals(this.unknownTypeClassName, tmAttributeDescriptor.unknownTypeClassName) &&
        Objects.equals(this.nullable, tmAttributeDescriptor.nullable) &&
        Objects.equals(this.description, tmAttributeDescriptor.description) &&
        Objects.equals(this.defaultValue, tmAttributeDescriptor.defaultValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, comment, type, unknownTypeClassName, nullable, description, defaultValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMAttributeDescriptor {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unknownTypeClassName: ").append(toIndentedString(unknownTypeClassName)).append("\n");
    sb.append("    nullable: ").append(toIndentedString(nullable)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

