package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.CheckboxFilterConfigurationAttributeValuesSettingsInner;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Configuration for a checkbox filter
 */

@Schema(name = "CheckboxFilterConfiguration", description = "Configuration for a checkbox filter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class CheckboxFilterConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  @Valid
  private List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings = new ArrayList<>();

  public CheckboxFilterConfiguration attributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
    return this;
  }

  public CheckboxFilterConfiguration addAttributeValuesSettingsItem(CheckboxFilterConfigurationAttributeValuesSettingsInner attributeValuesSettingsItem) {
    if (this.attributeValuesSettings == null) {
      this.attributeValuesSettings = new ArrayList<>();
    }
    this.attributeValuesSettings.add(attributeValuesSettingsItem);
    return this;
  }

  /**
   * settings for the attribute values
   * @return attributeValuesSettings
   */
  @Valid 
  @Schema(name = "attributeValuesSettings", description = "settings for the attribute values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributeValuesSettings")
  public List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> getAttributeValuesSettings() {
    return attributeValuesSettings;
  }

  public void setAttributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CheckboxFilterConfiguration checkboxFilterConfiguration = (CheckboxFilterConfiguration) o;
    return Objects.equals(this.attributeValuesSettings, checkboxFilterConfiguration.attributeValuesSettings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributeValuesSettings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CheckboxFilterConfiguration {\n");
    sb.append("    attributeValuesSettings: ").append(toIndentedString(attributeValuesSettings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

