package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.CheckboxFilterConfigurationAttributeValuesSettingsInner;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * configuration for editing filter
 */

@Schema(name = "Filter_editConfiguration", description = "configuration for editing filter")
@JsonTypeName("Filter_editConfiguration")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class FilterEditConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * the type of filter tool
   */
  public enum FilterToolEnum {
    SLIDER("SLIDER"),
    
    CHECKBOX("CHECKBOX");

    private final String value;

    FilterToolEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FilterToolEnum fromValue(String value) {
      for (FilterToolEnum b : FilterToolEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private FilterToolEnum filterTool;

  private Double minimumValue;

  private Double maximumValue;

  private Double initialValue;

  private Double initialLowerValue;

  private Double initialUpperValue;

  @Valid
  private List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings = new ArrayList<>();

  public FilterEditConfiguration filterTool(FilterToolEnum filterTool) {
    this.filterTool = filterTool;
    return this;
  }

  /**
   * the type of filter tool
   * @return filterTool
   */
  
  @Schema(name = "filterTool", description = "the type of filter tool", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filterTool")
  public FilterToolEnum getFilterTool() {
    return filterTool;
  }

  public void setFilterTool(FilterToolEnum filterTool) {
    this.filterTool = filterTool;
  }

  public FilterEditConfiguration minimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
    return this;
  }

  /**
   * minimum value for the slider
   * @return minimumValue
   */
  
  @Schema(name = "minimumValue", description = "minimum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minimumValue")
  public Double getMinimumValue() {
    return minimumValue;
  }

  public void setMinimumValue(Double minimumValue) {
    this.minimumValue = minimumValue;
  }

  public FilterEditConfiguration maximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
    return this;
  }

  /**
   * maximum value for the slider
   * @return maximumValue
   */
  
  @Schema(name = "maximumValue", description = "maximum value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maximumValue")
  public Double getMaximumValue() {
    return maximumValue;
  }

  public void setMaximumValue(Double maximumValue) {
    this.maximumValue = maximumValue;
  }

  public FilterEditConfiguration initialValue(Double initialValue) {
    this.initialValue = initialValue;
    return this;
  }

  /**
   * initial value for the slider
   * @return initialValue
   */
  
  @Schema(name = "initialValue", description = "initial value for the slider", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialValue")
  public Double getInitialValue() {
    return initialValue;
  }

  public void setInitialValue(Double initialValue) {
    this.initialValue = initialValue;
  }

  public FilterEditConfiguration initialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
    return this;
  }

  /**
   * initial lower value for a slider filter with between condition
   * @return initialLowerValue
   */
  
  @Schema(name = "initialLowerValue", description = "initial lower value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialLowerValue")
  public Double getInitialLowerValue() {
    return initialLowerValue;
  }

  public void setInitialLowerValue(Double initialLowerValue) {
    this.initialLowerValue = initialLowerValue;
  }

  public FilterEditConfiguration initialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
    return this;
  }

  /**
   * initial upper value for a slider filter with between condition
   * @return initialUpperValue
   */
  
  @Schema(name = "initialUpperValue", description = "initial upper value for a slider filter with between condition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("initialUpperValue")
  public Double getInitialUpperValue() {
    return initialUpperValue;
  }

  public void setInitialUpperValue(Double initialUpperValue) {
    this.initialUpperValue = initialUpperValue;
  }

  public FilterEditConfiguration attributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
    return this;
  }

  public FilterEditConfiguration addAttributeValuesSettingsItem(CheckboxFilterConfigurationAttributeValuesSettingsInner attributeValuesSettingsItem) {
    if (this.attributeValuesSettings == null) {
      this.attributeValuesSettings = new ArrayList<>();
    }
    this.attributeValuesSettings.add(attributeValuesSettingsItem);
    return this;
  }

  /**
   * settings for the attribute values
   * @return attributeValuesSettings
   */
  @Valid 
  @Schema(name = "attributeValuesSettings", description = "settings for the attribute values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributeValuesSettings")
  public List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> getAttributeValuesSettings() {
    return attributeValuesSettings;
  }

  public void setAttributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
    this.attributeValuesSettings = attributeValuesSettings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FilterEditConfiguration filterEditConfiguration = (FilterEditConfiguration) o;
    return Objects.equals(this.filterTool, filterEditConfiguration.filterTool) &&
        Objects.equals(this.minimumValue, filterEditConfiguration.minimumValue) &&
        Objects.equals(this.maximumValue, filterEditConfiguration.maximumValue) &&
        Objects.equals(this.initialValue, filterEditConfiguration.initialValue) &&
        Objects.equals(this.initialLowerValue, filterEditConfiguration.initialLowerValue) &&
        Objects.equals(this.initialUpperValue, filterEditConfiguration.initialUpperValue) &&
        Objects.equals(this.attributeValuesSettings, filterEditConfiguration.attributeValuesSettings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filterTool, minimumValue, maximumValue, initialValue, initialLowerValue, initialUpperValue, attributeValuesSettings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FilterEditConfiguration {\n");
    sb.append("    filterTool: ").append(toIndentedString(filterTool)).append("\n");
    sb.append("    minimumValue: ").append(toIndentedString(minimumValue)).append("\n");
    sb.append("    maximumValue: ").append(toIndentedString(maximumValue)).append("\n");
    sb.append("    initialValue: ").append(toIndentedString(initialValue)).append("\n");
    sb.append("    initialLowerValue: ").append(toIndentedString(initialLowerValue)).append("\n");
    sb.append("    initialUpperValue: ").append(toIndentedString(initialUpperValue)).append("\n");
    sb.append("    attributeValuesSettings: ").append(toIndentedString(attributeValuesSettings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

