package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model for a page tile as returned by the api for the viewer
 */

@Schema(name = "ViewerPageTile", description = "model for a page tile as returned by the api for the viewer")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class ViewerPageTile implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title;

  private String content;

  private String image = null;

  private String applicationUrl = null;

  private String pageUrl = null;

  private String url = null;

  private String className = null;

  private Boolean applicationRequiresLogin = null;

  private Boolean openInNewWindow = null;

  public ViewerPageTile title(String title) {
    this.title = title;
    return this;
  }

  /**
   * page tile title
   * @return title
   */
  
  @Schema(name = "title", description = "page tile title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public ViewerPageTile content(String content) {
    this.content = content;
    return this;
  }

  /**
   * page tile contents
   * @return content
   */
  
  @Schema(name = "content", description = "page tile contents", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public ViewerPageTile image(String image) {
    this.image = image;
    return this;
  }

  /**
   * image to show on the tile
   * @return image
   */
  
  @Schema(name = "image", description = "image to show on the tile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("image")
  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }

  public ViewerPageTile applicationUrl(String applicationUrl) {
    this.applicationUrl = applicationUrl;
    return this;
  }

  /**
   * link to the application
   * @return applicationUrl
   */
  
  @Schema(name = "applicationUrl", description = "link to the application", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("applicationUrl")
  public String getApplicationUrl() {
    return applicationUrl;
  }

  public void setApplicationUrl(String applicationUrl) {
    this.applicationUrl = applicationUrl;
  }

  public ViewerPageTile pageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
    return this;
  }

  /**
   * link to another page
   * @return pageUrl
   */
  
  @Schema(name = "pageUrl", description = "link to another page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageUrl")
  public String getPageUrl() {
    return pageUrl;
  }

  public void setPageUrl(String pageUrl) {
    this.pageUrl = pageUrl;
  }

  public ViewerPageTile url(String url) {
    this.url = url;
    return this;
  }

  /**
   * link to an other domain / website
   * @return url
   */
  
  @Schema(name = "url", description = "link to an other domain / website", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public ViewerPageTile className(String className) {
    this.className = className;
    return this;
  }

  /**
   * optional css classname for styling
   * @return className
   */
  
  @Schema(name = "className", description = "optional css classname for styling", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("className")
  public String getClassName() {
    return className;
  }

  public void setClassName(String className) {
    this.className = className;
  }

  public ViewerPageTile applicationRequiresLogin(Boolean applicationRequiresLogin) {
    this.applicationRequiresLogin = applicationRequiresLogin;
    return this;
  }

  /**
   * indicates if the user will need to login for the linked application
   * @return applicationRequiresLogin
   */
  
  @Schema(name = "applicationRequiresLogin", description = "indicates if the user will need to login for the linked application", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("applicationRequiresLogin")
  public Boolean getApplicationRequiresLogin() {
    return applicationRequiresLogin;
  }

  public void setApplicationRequiresLogin(Boolean applicationRequiresLogin) {
    this.applicationRequiresLogin = applicationRequiresLogin;
  }

  public ViewerPageTile openInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
    return this;
  }

  /**
   * indicates whether the link should be opened in a new window
   * @return openInNewWindow
   */
  
  @Schema(name = "openInNewWindow", description = "indicates whether the link should be opened in a new window", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("openInNewWindow")
  public Boolean getOpenInNewWindow() {
    return openInNewWindow;
  }

  public void setOpenInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViewerPageTile viewerPageTile = (ViewerPageTile) o;
    return Objects.equals(this.title, viewerPageTile.title) &&
        Objects.equals(this.content, viewerPageTile.content) &&
        Objects.equals(this.image, viewerPageTile.image) &&
        Objects.equals(this.applicationUrl, viewerPageTile.applicationUrl) &&
        Objects.equals(this.pageUrl, viewerPageTile.pageUrl) &&
        Objects.equals(this.url, viewerPageTile.url) &&
        Objects.equals(this.className, viewerPageTile.className) &&
        Objects.equals(this.applicationRequiresLogin, viewerPageTile.applicationRequiresLogin) &&
        Objects.equals(this.openInNewWindow, viewerPageTile.openInNewWindow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, content, image, applicationUrl, pageUrl, url, className, applicationRequiresLogin, openInNewWindow);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViewerPageTile {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    applicationUrl: ").append(toIndentedString(applicationUrl)).append("\n");
    sb.append("    pageUrl: ").append(toIndentedString(pageUrl)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    applicationRequiresLogin: ").append(toIndentedString(applicationRequiresLogin)).append("\n");
    sb.append("    openInNewWindow: ").append(toIndentedString(openInNewWindow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

