/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="TaskProgressEvent", description="Task progress event. This event is sent when a _running_ task makes progress, including start/stop. The fraction of the task that is done can be computed using `progress` and `total` (if not null).")
public class TaskProgressEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type;
    private UUID uuid;
    private Integer total = null;
    private Integer progress = 0;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startedAt = null;
    @Valid
    private Map<String, Object> taskData;

    public TaskProgressEvent type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="type", example="index", description="Type of the task.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TaskProgressEvent uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="uuid", description="UUID of the task; this, combined with type, is used to uniquely identify the task.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public TaskProgressEvent total(Integer total) {
        this.total = total;
        return this;
    }

    @Schema(name="total", example="1200", description="Total number of items to process. May be `null` or empty if unknown.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public TaskProgressEvent progress(Integer progress) {
        this.progress = progress;
        return this;
    }

    @NotNull
    @Schema(name="progress", example="113", description="Number of items processed so far.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="progress")
    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public TaskProgressEvent startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Valid
    @Schema(name="startedAt", example="2024-12-12T16:02:34.587142504+01:00", description="Zoned date-time when the task started.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startedAt")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public TaskProgressEvent taskData(Map<String, Object> taskData) {
        this.taskData = taskData;
        return this;
    }

    public TaskProgressEvent putTaskDataItem(String key, Object taskDataItem) {
        if (this.taskData == null) {
            this.taskData = new HashMap<String, Object>();
        }
        this.taskData.put(key, taskDataItem);
        return this;
    }

    @Schema(name="taskData", example="{\"index\":1}", description="Additional data for the task.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="taskData")
    public Map<String, Object> getTaskData() {
        return this.taskData;
    }

    public void setTaskData(Map<String, Object> taskData) {
        this.taskData = taskData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskProgressEvent taskProgressEvent = (TaskProgressEvent)o;
        return Objects.equals(this.type, taskProgressEvent.type) && Objects.equals(this.uuid, taskProgressEvent.uuid) && Objects.equals(this.total, taskProgressEvent.total) && Objects.equals(this.progress, taskProgressEvent.progress) && Objects.equals(this.startedAt, taskProgressEvent.startedAt) && Objects.equals(this.taskData, taskProgressEvent.taskData);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.uuid, this.total, this.progress, this.startedAt, this.taskData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskProgressEvent {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    taskData: ").append(this.toIndentedString(this.taskData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

