/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SourceMapSecurityFilter
implements Filter {
    @Value(value="${tailormap-api.source-map.auth:#null}")
    private String sourceMapAuth;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        if (!"public".equals(this.sourceMapAuth)) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String path = request.getRequestURI().substring(request.getContextPath().length());
            if (!path.startsWith("/api/") && path.endsWith(".map")) {
                if (this.sourceMapAuth == null) {
                    response.sendError(403);
                    return;
                }
                String sourceMapAuthorization = "Basic " + Base64.getEncoder().encodeToString(this.sourceMapAuth.getBytes(StandardCharsets.UTF_8));
                if (!sourceMapAuthorization.equals(request.getHeader("Authorization"))) {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"Source maps\"");
                    response.sendError(401);
                    return;
                }
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }
}

