/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.TMFeatureTypeHelper;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.viewer.model.UniqueValuesResponse;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/unique/{attributeName}"}, produces={"application/json"})
public class UniqueValuesController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureSourceRepository featureSourceRepository;
    @Value(value="${tailormap-api.unique.use_geotools_unique_function:true}")
    private boolean useGeotoolsUniqueFunction;
    private final FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    public UniqueValuesController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureSourceRepository featureSourceRepository) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureSourceRepository = featureSourceRepository;
    }

    @Transactional
    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    @Timed(value="get_unique_attributes", description="time spent to process get unique attributes call")
    @Counted(value="get_unique_attributes", description="number of unique attributes calls")
    public ResponseEntity<Serializable> getUniqueAttributes(@ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @ModelAttribute Application app, @ModelAttribute AppTreeLayerNode appTreeLayerNode, @PathVariable(value="attributeName") String attributeName, @RequestParam(required=false) String filter) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Attribute name is required");
        }
        TMFeatureType tmft = service.findFeatureTypeForLayer(layer, this.featureSourceRepository);
        AppLayerSettings appLayerSettings = app.getAppLayerSettings(appTreeLayerNode);
        if (tmft == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Layer does not have feature type");
        }
        if (!TMFeatureTypeHelper.getNonHiddenAttributeNames(tmft, appLayerSettings).contains(attributeName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Attribute does not exist");
        }
        UniqueValuesResponse uniqueValuesResponse = this.getUniqueValues(tmft, attributeName, filter);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)uniqueValuesResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UniqueValuesResponse getUniqueValues(TMFeatureType tmft, String attributeName, String filter) {
        UniqueValuesResponse uniqueValuesResponse = new UniqueValuesResponse().filterApplied(false);
        SimpleFeatureSource fs = null;
        try {
            Not notNull;
            Filter existingFilter = null;
            if (null != filter) {
                existingFilter = ECQL.toFilter((String)filter);
            }
            logger.trace("existingFilter: {}", (Object)existingFilter);
            Not f = notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(attributeName)));
            if (null != existingFilter) {
                f = this.ff.and((Filter)notNull, existingFilter);
                uniqueValuesResponse.filterApplied(true);
            }
            Query q = new Query(tmft.getName(), (Filter)f);
            q.setPropertyNames(new String[]{attributeName});
            q.setSortBy(new SortBy[]{this.ff.sort(attributeName, SortOrder.ASCENDING)});
            logger.trace("Unique values query: {}", (Object)q);
            fs = this.featureSourceFactoryHelper.openGeoToolsFeatureSource(tmft);
            if (!this.useGeotoolsUniqueFunction) {
                logger.trace("Using feature visitor to get unique values");
                fs.getFeatures(q).accepts(feature -> uniqueValuesResponse.addValuesItem(feature.getProperty(attributeName).getValue()), null);
            } else {
                logger.trace("Using geotools unique collection function to get unique values");
                Function unique = this.ff.function("Collection_Unique", new Expression[]{this.ff.property(attributeName)});
                Object o = unique.evaluate((Object)fs.getFeatures(q));
                if (o instanceof Set) {
                    Set uniqueValues = (Set)o;
                    uniqueValuesResponse.setValues(new TreeSet<Object>(uniqueValues));
                }
            }
        }
        catch (CQLException e) {
            logger.error("Could not parse requested filter", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Could not parse requested filter");
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data", (Throwable)e);
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        return uniqueValuesResponse;
    }
}

