/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.quartz.CronTrigger;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerUtils;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.scheduling.TaskManagerService;
import org.tailormap.api.scheduling.TaskType;

@RestController
public class TaskAdminController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Scheduler scheduler;
    private final TaskManagerService taskManagerService;
    private final SearchIndexRepository searchIndexRepository;

    public TaskAdminController(@Autowired Scheduler scheduler, @Autowired TaskManagerService taskManagerService, @Autowired SearchIndexRepository searchIndexRepository) {
        this.scheduler = scheduler;
        this.taskManagerService = taskManagerService;
        this.searchIndexRepository = searchIndexRepository;
    }

    @Operation(summary="List all tasks, optionally filtered by type", description="This will return a list of all tasks, optionally filtered by task type.\nThe state of the task is one of the Quartz Trigger states.\nThe state can be one of: NONE, NORMAL, PAUSED, COMPLETE, ERROR, BLOCKED or null in error conditions.\n")
    @GetMapping(path={"${tailormap-api.admin.base-path}/tasks"}, produces={"application/json"})
    @ApiResponse(responseCode="200", description="List of all tasks, this list may be empty", content={@Content(mediaType="application/json", schema=@Schema(example="{\"tasks\":[\n{\"uuid\":\"6308d26e-fe1e-4268-bb28-20db2cd06914\",\"type\":\"index\", \"state\":\"NORMAL\", \"interruptable\": false},\n{\"uuid\":\"d5ce9152-e90e-4b5a-b129-3b2366cabca8\",\"type\":\"poc\", \"state\": \"BLOCKED\", \"interruptable\": false},\n{\"uuid\":\"d5ce9152-e90e-4b5a-b129-3b2366cabca9\",\"type\":\"poc\", \"state\": \"PAUSED\", \"interruptable\": false},\n{\"uuid\":\"d5ce9152-e90e-4b5a-b129-3b2366cabca2\",\"type\":\"poc\", \"state\": \"COMPLETE\", \"interruptable\": false},\n{\"uuid\":\"d5ce9152-e90e-4b5a-b129-3b2366cabca3\",\"type\":\"interuptablepoc\", \"state\": \"ERROR\", \"interruptable\": true}\n]}\n"))})
    public ResponseEntity<Object> list(@RequestParam(required=false) String type) throws ResponseStatusException {
        logger.debug("Listing all tasks (optional type filter: {})", (Object)(null == type ? "all" : type));
        ArrayList tasks = new ArrayList();
        GroupMatcher groupMatcher = null == type ? GroupMatcher.anyGroup() : GroupMatcher.groupEquals((String)type);
        try {
            this.scheduler.getJobKeys(groupMatcher).stream().map(jobKey -> {
                try {
                    return this.scheduler.getJobDetail(jobKey);
                }
                catch (SchedulerException e) {
                    logger.error("Error getting task detail", (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).forEach(jobDetail -> {
                Trigger.TriggerState state;
                try {
                    state = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobDetail.getKey().getName(), (String)jobDetail.getKey().getGroup()));
                }
                catch (SchedulerException e) {
                    logger.error("Error getting task state", (Throwable)e);
                    state = null;
                }
                tasks.add(new ObjectMapper().createObjectNode().put("type", jobDetail.getKey().getGroup()).put("uuid", jobDetail.getKey().getName()).put("interruptable", InterruptableJob.class.isAssignableFrom(jobDetail.getJobClass())).put("description", jobDetail.getJobDataMap().getString("description")).put("lastResult", jobDetail.getJobDataMap().getString("lastResult")).putPOJO("state", (Object)state));
            });
        }
        catch (SchedulerException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error getting tasks", (Throwable)e);
        }
        return ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().set("tasks", (JsonNode)new ObjectMapper().createArrayNode().addAll(tasks)));
    }

    @Operation(summary="List all details for a given task", description="This will return the details of the task, including the status, progress,\nresult and any other information.\n")
    @GetMapping(path={"${tailormap-api.admin.base-path}/tasks/{type}/{uuid}"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Task not found", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Task not found\",\"code\":404}"))}), @ApiResponse(responseCode="200", description="Details of the task. The response content will vay according to the type of task,\nthe most common fields are listed in the Task interface.\n", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"type\":\"poc\",\n\"uuid\":\"6308d26e-fe1e-4268-bb28-20db2cd06914\",\n\"interruptable\":false,\n\"description\":\"This is a poc task\",\n\"startTime\":\"2024-06-06T12:00:00Z\",\n\"nextTime\":\"2024-06-06T12:00:00Z\",\n\"state\":\"NORMAL\",\n\"progress\":\"...\",\n\"result\":\"...\",\n\"message\":\"something is happening\"\n\"jobData\":{ \"type\":\"poc\", \"description\":\"This is a poc task\" }\n}\n"))})})
    public ResponseEntity<Object> details(@PathVariable TaskType type, @PathVariable UUID uuid) throws ResponseStatusException {
        logger.debug("Getting task details for {}:{}", (Object)type, (Object)uuid);
        try {
            JobKey jobKey = this.taskManagerService.getJobKey(type, uuid);
            if (null == jobKey) {
                return this.handleTaskNotFound();
            }
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            Trigger trigger = (Trigger)this.scheduler.getTriggersOfJob(jobDetail.getKey()).get(0);
            CronTrigger cron = (CronTrigger)trigger;
            Object[] result = new Object[1];
            this.scheduler.getCurrentlyExecutingJobs().stream().filter(Objects::nonNull).filter(jobExecutionContext -> jobExecutionContext.getJobDetail().getKey().equals((Object)jobKey)).forEach(jobExecutionContext -> {
                logger.debug("currently executing job {} with trigger {}.", (Object)jobExecutionContext.getJobDetail().getKey(), (Object)jobExecutionContext.getTrigger().getKey());
                result[0] = jobExecutionContext.getResult();
            });
            return ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().put("type", jobDetail.getKey().getGroup()).put("uuid", jobDetail.getKey().getName()).put("interruptable", InterruptableJob.class.isAssignableFrom(jobDetail.getJobClass())).put("description", jobDataMap.getString("description")).put("cronExpression", cron.getCronExpression()).put("timezone", cron.getTimeZone().getID()).putPOJO("startTime", (Object)trigger.getStartTime()).putPOJO("lastTime", (Object)trigger.getPreviousFireTime()).putPOJO("nextFireTimes", (Object)TriggerUtils.computeFireTimes((OperableTrigger)((OperableTrigger)cron), null, (int)5)).putPOJO("state", (Object)this.scheduler.getTriggerState(trigger.getKey())).putPOJO("progress", result[0]).put("lastResult", jobDataMap.getString("lastResult")).putPOJO("jobData", (Object)jobDataMap));
        }
        catch (SchedulerException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error getting task", (Throwable)e);
        }
    }

    @Operation(summary="Start a task", description="This will start the task if it is not already running")
    @PutMapping(path={"${tailormap-api.admin.base-path}/tasks/{type}/{uuid}/start"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Task not found", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Task not found\",\"code\":404}"))}), @ApiResponse(responseCode="202", description="Task is started", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Task starting accepted\",\"code\":202}"))})})
    public ResponseEntity<Object> startTask(@PathVariable TaskType type, @PathVariable UUID uuid) throws ResponseStatusException {
        logger.debug("Starting task {}:{}", (Object)type, (Object)uuid);
        try {
            JobKey jobKey = this.taskManagerService.getJobKey(type, uuid);
            if (null == jobKey) {
                return this.handleTaskNotFound();
            }
            this.scheduler.triggerJob(jobKey);
            return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)202)).body((Object)new ObjectMapper().createObjectNode().put("message", "Task starting accepted"));
        }
        catch (SchedulerException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error getting task", (Throwable)e);
        }
    }

    @Operation(summary="Stop a task irrevocably", description="This will stop a running task, if the task is not running, nothing will happen.\nThis can leave the application in an inconsistent state.\nA task that is not interruptable cannot be stopped.\nA stopped task cannot be restarted, it fire again depending on the schedule.\n")
    @PutMapping(path={"${tailormap-api.admin.base-path}/tasks/{type}/{uuid}/stop"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Task not found", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Task not found\", \"code\":404}"))}), @ApiResponse(responseCode="202", description="Task is stopping", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"message\":\"Task stopping accepted\".\n\"succes\":true\n}\n"))}), @ApiResponse(responseCode="400", description="The task cannot be stopped as it does not implement the InterruptableJob interface.", content={@Content(mediaType="application/json", schema=@Schema(example="{ \"message\":\"Task cannot be stopped\" }\n"))})})
    public ResponseEntity<Object> stopTask(@PathVariable TaskType type, @PathVariable UUID uuid) throws ResponseStatusException {
        logger.debug("Stopping task {}:{}", (Object)type, (Object)uuid);
        try {
            JobKey jobKey = this.taskManagerService.getJobKey(type, uuid);
            if (null == jobKey) {
                return this.handleTaskNotFound();
            }
            if (InterruptableJob.class.isAssignableFrom(this.scheduler.getJobDetail(jobKey).getJobClass())) {
                boolean interrupted = this.scheduler.interrupt(jobKey);
                return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)202)).body((Object)new ObjectMapper().createObjectNode().put("message", "Task stopping accepted").put("succes", interrupted));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)400)).body((Object)new ObjectMapper().createObjectNode().put("message", "Task cannot be stopped").put("succes", false));
        }
        catch (SchedulerException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error getting task", (Throwable)e);
        }
    }

    @Operation(summary="Delete a task", description="This will remove the task from the scheduler and delete all information about the task")
    @DeleteMapping(path={"${tailormap-api.admin.base-path}/tasks/{type}/{uuid}"}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="404", description="Task not found", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Task not found\"}"))}), @ApiResponse(responseCode="204", description="Task is deleted")})
    public ResponseEntity<Object> delete(@PathVariable TaskType type, @PathVariable UUID uuid) throws ResponseStatusException {
        try {
            JobKey jobKey = this.taskManagerService.getJobKey(type, uuid);
            if (null == jobKey) {
                return this.handleTaskNotFound();
            }
            boolean succes = this.scheduler.deleteJob(jobKey);
            logger.info("Task {}:{} deletion {}", new Object[]{type, uuid, succes ? "succeeded" : "failed"});
            switch (type) {
                case INDEX: {
                    this.deleteScheduleFromSearchIndex(uuid);
                    break;
                }
            }
            return ResponseEntity.noContent().build();
        }
        catch (SchedulerException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error getting task", (Throwable)e);
        }
    }

    private void deleteScheduleFromSearchIndex(UUID uuid) {
        this.searchIndexRepository.findByTaskScheduleUuid(uuid).forEach(searchIndex -> {
            searchIndex.setSchedule(null);
            this.searchIndexRepository.save(searchIndex);
        });
    }

    private ResponseEntity<Object> handleTaskNotFound() {
        return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)404)).contentType(MediaType.APPLICATION_JSON).body((Object)new ObjectMapper().createObjectNode().put("message", "Task not found").put("code", 404));
    }
}

