/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.AppTreeNode;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="AppContent", description="Configuration for including content (layers) in an application.")
public class AppContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    private List<AppTreeNode> baseLayerNodes = new ArrayList<AppTreeNode>();
    @Valid
    private List<AppTreeNode> layerNodes = new ArrayList<AppTreeNode>();
    @Valid
    private List<AppTreeNode> terrainLayerNodes;

    public AppContent baseLayerNodes(List<AppTreeNode> baseLayerNodes) {
        this.baseLayerNodes = baseLayerNodes;
        return this;
    }

    public AppContent addBaseLayerNodesItem(AppTreeNode baseLayerNodesItem) {
        if (this.baseLayerNodes == null) {
            this.baseLayerNodes = new ArrayList<AppTreeNode>();
        }
        this.baseLayerNodes.add(baseLayerNodesItem);
        return this;
    }

    @Valid
    @Schema(name="baseLayerNodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="baseLayerNodes")
    public List<AppTreeNode> getBaseLayerNodes() {
        return this.baseLayerNodes;
    }

    public void setBaseLayerNodes(List<AppTreeNode> baseLayerNodes) {
        this.baseLayerNodes = baseLayerNodes;
    }

    public AppContent layerNodes(List<AppTreeNode> layerNodes) {
        this.layerNodes = layerNodes;
        return this;
    }

    public AppContent addLayerNodesItem(AppTreeNode layerNodesItem) {
        if (this.layerNodes == null) {
            this.layerNodes = new ArrayList<AppTreeNode>();
        }
        this.layerNodes.add(layerNodesItem);
        return this;
    }

    @Valid
    @Schema(name="layerNodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="layerNodes")
    public List<AppTreeNode> getLayerNodes() {
        return this.layerNodes;
    }

    public void setLayerNodes(List<AppTreeNode> layerNodes) {
        this.layerNodes = layerNodes;
    }

    public AppContent terrainLayerNodes(List<AppTreeNode> terrainLayerNodes) {
        this.terrainLayerNodes = terrainLayerNodes;
        return this;
    }

    public AppContent addTerrainLayerNodesItem(AppTreeNode terrainLayerNodesItem) {
        if (this.terrainLayerNodes == null) {
            this.terrainLayerNodes = new ArrayList<AppTreeNode>();
        }
        this.terrainLayerNodes.add(terrainLayerNodesItem);
        return this;
    }

    @Valid
    @Schema(name="terrainLayerNodes", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="terrainLayerNodes")
    public List<AppTreeNode> getTerrainLayerNodes() {
        return this.terrainLayerNodes;
    }

    public void setTerrainLayerNodes(List<AppTreeNode> terrainLayerNodes) {
        this.terrainLayerNodes = terrainLayerNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppContent appContent = (AppContent)o;
        return Objects.equals(this.baseLayerNodes, appContent.baseLayerNodes) && Objects.equals(this.layerNodes, appContent.layerNodes) && Objects.equals(this.terrainLayerNodes, appContent.terrainLayerNodes);
    }

    public int hashCode() {
        return Objects.hash(this.baseLayerNodes, this.layerNodes, this.terrainLayerNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppContent {\n");
        sb.append("    baseLayerNodes: ").append(this.toIndentedString(this.baseLayerNodes)).append("\n");
        sb.append("    layerNodes: ").append(this.toIndentedString(this.layerNodes)).append("\n");
        sb.append("    terrainLayerNodes: ").append(this.toIndentedString(this.terrainLayerNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

