/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.FilterEditConfiguration;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="Filter", description="A filter for an attribute. The filter can be used to filter the features of a layer, based on attribute value")
public class Filter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private TypeEnum type;
    private ConditionEnum condition;
    private Boolean invertCondition = false;
    private String attribute;
    private AttributeTypeEnum attributeType;
    @Valid
    private List<String> value = new ArrayList<String>();
    private Boolean caseSensitive = false;
    private FilterEditConfiguration editConfiguration;

    public Filter id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="id of the filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Filter type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="type of the filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Filter condition(ConditionEnum condition) {
        this.condition = condition;
        return this;
    }

    @Schema(name="condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="condition")
    public ConditionEnum getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionEnum condition) {
        this.condition = condition;
    }

    public Filter invertCondition(Boolean invertCondition) {
        this.invertCondition = invertCondition;
        return this;
    }

    @Schema(name="invertCondition", description="when true the condition is to be inverted", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="invertCondition")
    public Boolean getInvertCondition() {
        return this.invertCondition;
    }

    public void setInvertCondition(Boolean invertCondition) {
        this.invertCondition = invertCondition;
    }

    public Filter attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Schema(name="attribute", description="name of the attribute", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribute")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Filter attributeType(AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @Schema(name="attributeType", description="type of the attribute", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attributeType")
    public AttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
    }

    public Filter value(List<String> value) {
        this.value = value;
        return this;
    }

    public Filter addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    @Schema(name="value", description="value of the filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value")
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public Filter caseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    @Schema(name="caseSensitive", description="true when the filter is case sensitive", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="caseSensitive")
    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Filter editConfiguration(FilterEditConfiguration editConfiguration) {
        this.editConfiguration = editConfiguration;
        return this;
    }

    @Valid
    @Schema(name="editConfiguration", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editConfiguration")
    public FilterEditConfiguration getEditConfiguration() {
        return this.editConfiguration;
    }

    public void setEditConfiguration(FilterEditConfiguration editConfiguration) {
        this.editConfiguration = editConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equals(this.id, filter.id) && Objects.equals((Object)this.type, (Object)filter.type) && Objects.equals((Object)this.condition, (Object)filter.condition) && Objects.equals(this.invertCondition, filter.invertCondition) && Objects.equals(this.attribute, filter.attribute) && Objects.equals((Object)this.attributeType, (Object)filter.attributeType) && Objects.equals(this.value, filter.value) && Objects.equals(this.caseSensitive, filter.caseSensitive) && Objects.equals(this.editConfiguration, filter.editConfiguration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.condition, this.invertCondition, this.attribute, this.attributeType, this.value, this.caseSensitive, this.editConfiguration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Filter {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString((Object)this.condition)).append("\n");
        sb.append("    invertCondition: ").append(this.toIndentedString(this.invertCondition)).append("\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    attributeType: ").append(this.toIndentedString((Object)this.attributeType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    caseSensitive: ").append(this.toIndentedString(this.caseSensitive)).append("\n");
        sb.append("    editConfiguration: ").append(this.toIndentedString(this.editConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ATTRIBUTE("ATTRIBUTE");

        private final String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ConditionEnum {
        UNIQUE_VALUES("UNIQUE_VALUES"),
        EQUAL("="),
        NOT_EQUAL("<>"),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_THAN_OR_EQUAL_TO(">="),
        LESS_THAN_OR_EQUAL_TO("<="),
        u("><"),
        EQUALS("EQUALS"),
        LIKE("LIKE"),
        STARTS_WITH("STARTS_WITH"),
        ENDS_WITH("ENDS_WITH"),
        ON("ON"),
        AFTER("AFTER"),
        BEFORE("BEFORE"),
        BETWEEN("BETWEEN"),
        TRUE("TRUE"),
        FALSE("FALSE"),
        NULL("NULL");

        private final String value;

        private ConditionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConditionEnum fromValue(String value) {
            for (ConditionEnum b : ConditionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AttributeTypeEnum {
        DATE("date"),
        TIMESTAMP("timestamp"),
        STRING("string"),
        DOUBLE("double"),
        NUMBER("number"),
        INTEGER("integer"),
        BOOLEAN("boolean");

        private final String value;

        private AttributeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AttributeTypeEnum fromValue(String value) {
            for (AttributeTypeEnum b : AttributeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

