/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="PageTile", description="model for a page tile")
public class PageTile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private String content;
    private String image = null;
    private Long applicationId = null;
    private Long pageId = null;
    private String url = null;
    private String className = null;
    private Boolean filterRequireAuthorization = null;
    private Boolean openInNewWindow = null;

    public PageTile id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PageTile title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="page tile title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PageTile content(String content) {
        this.content = content;
        return this;
    }

    @Schema(name="content", description="page tile contents", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public PageTile image(String image) {
        this.image = image;
        return this;
    }

    @Schema(name="image", description="image to show on the tile", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public PageTile applicationId(Long applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Schema(name="applicationId", description="linked application", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="applicationId")
    public Long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public PageTile pageId(Long pageId) {
        this.pageId = pageId;
        return this;
    }

    @Schema(name="pageId", description="linked page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageId")
    public Long getPageId() {
        return this.pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public PageTile url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="link to an other domain / website", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public PageTile className(String className) {
        this.className = className;
        return this;
    }

    @Schema(name="className", description="optional css classname for styling", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="className")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public PageTile filterRequireAuthorization(Boolean filterRequireAuthorization) {
        this.filterRequireAuthorization = filterRequireAuthorization;
        return this;
    }

    @Schema(name="filterRequireAuthorization", description="indicates if this tile should be filtered from the list if an application id is set for which the user does not have access", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filterRequireAuthorization")
    public Boolean getFilterRequireAuthorization() {
        return this.filterRequireAuthorization;
    }

    public void setFilterRequireAuthorization(Boolean filterRequireAuthorization) {
        this.filterRequireAuthorization = filterRequireAuthorization;
    }

    public PageTile openInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
        return this;
    }

    @Schema(name="openInNewWindow", description="indicates whether the link should be opened in a new window", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="openInNewWindow")
    public Boolean getOpenInNewWindow() {
        return this.openInNewWindow;
    }

    public void setOpenInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageTile pageTile = (PageTile)o;
        return Objects.equals(this.id, pageTile.id) && Objects.equals(this.title, pageTile.title) && Objects.equals(this.content, pageTile.content) && Objects.equals(this.image, pageTile.image) && Objects.equals(this.applicationId, pageTile.applicationId) && Objects.equals(this.pageId, pageTile.pageId) && Objects.equals(this.url, pageTile.url) && Objects.equals(this.className, pageTile.className) && Objects.equals(this.filterRequireAuthorization, pageTile.filterRequireAuthorization) && Objects.equals(this.openInNewWindow, pageTile.openInNewWindow);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.content, this.image, this.applicationId, this.pageId, this.url, this.className, this.filterRequireAuthorization, this.openInNewWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageTile {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    filterRequireAuthorization: ").append(this.toIndentedString(this.filterRequireAuthorization)).append("\n");
        sb.append("    openInNewWindow: ").append(this.toIndentedString(this.openInNewWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

