/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="SliderFilterConfiguration", description="Configuration for a slider filter")
public class SliderFilterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double minimumValue;
    private Double maximumValue;
    private Double initialValue;
    private Double initialLowerValue;
    private Double initialUpperValue;

    public SliderFilterConfiguration minimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
        return this;
    }

    @Schema(name="minimumValue", description="minimum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minimumValue")
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public SliderFilterConfiguration maximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
        return this;
    }

    @Schema(name="maximumValue", description="maximum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maximumValue")
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public SliderFilterConfiguration initialValue(Double initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Schema(name="initialValue", description="initial value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialValue")
    public Double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Double initialValue) {
        this.initialValue = initialValue;
    }

    public SliderFilterConfiguration initialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
        return this;
    }

    @Schema(name="initialLowerValue", description="initial lower value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerValue")
    public Double getInitialLowerValue() {
        return this.initialLowerValue;
    }

    public void setInitialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
    }

    public SliderFilterConfiguration initialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
        return this;
    }

    @Schema(name="initialUpperValue", description="initial upper value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperValue")
    public Double getInitialUpperValue() {
        return this.initialUpperValue;
    }

    public void setInitialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliderFilterConfiguration sliderFilterConfiguration = (SliderFilterConfiguration)o;
        return Objects.equals(this.minimumValue, sliderFilterConfiguration.minimumValue) && Objects.equals(this.maximumValue, sliderFilterConfiguration.maximumValue) && Objects.equals(this.initialValue, sliderFilterConfiguration.initialValue) && Objects.equals(this.initialLowerValue, sliderFilterConfiguration.initialLowerValue) && Objects.equals(this.initialUpperValue, sliderFilterConfiguration.initialUpperValue);
    }

    public int hashCode() {
        return Objects.hash(this.minimumValue, this.maximumValue, this.initialValue, this.initialLowerValue, this.initialUpperValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SliderFilterConfiguration {\n");
        sb.append("    minimumValue: ").append(this.toIndentedString(this.minimumValue)).append("\n");
        sb.append("    maximumValue: ").append(this.toIndentedString(this.maximumValue)).append("\n");
        sb.append("    initialValue: ").append(this.toIndentedString(this.initialValue)).append("\n");
        sb.append("    initialLowerValue: ").append(this.toIndentedString(this.initialLowerValue)).append("\n");
        sb.append("    initialUpperValue: ").append(this.toIndentedString(this.initialUpperValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

