/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="ViewerMenuItem", description="model for a menu item for pages")
public class ViewerMenuItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String label;
    private String pageUrl = null;
    private String url = null;
    private Boolean openInNewWindow = null;

    public ViewerMenuItem label(String label) {
        this.label = label;
        return this;
    }

    @Schema(name="label", description="menu item label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ViewerMenuItem pageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    @Schema(name="pageUrl", description="link to another page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageUrl")
    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public ViewerMenuItem url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="url", description="link to an other domain / website", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ViewerMenuItem openInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
        return this;
    }

    @Schema(name="openInNewWindow", description="indicates whether the link should be opened in a new window", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="openInNewWindow")
    public Boolean getOpenInNewWindow() {
        return this.openInNewWindow;
    }

    public void setOpenInNewWindow(Boolean openInNewWindow) {
        this.openInNewWindow = openInNewWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewerMenuItem viewerMenuItem = (ViewerMenuItem)o;
        return Objects.equals(this.label, viewerMenuItem.label) && Objects.equals(this.pageUrl, viewerMenuItem.pageUrl) && Objects.equals(this.url, viewerMenuItem.url) && Objects.equals(this.openInNewWindow, viewerMenuItem.openInNewWindow);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.pageUrl, this.url, this.openInNewWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewerMenuItem {\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    pageUrl: ").append(this.toIndentedString(this.pageUrl)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    openInNewWindow: ").append(this.toIndentedString(this.openInNewWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

