/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import java.lang.invoke.MethodHandles;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.tailormap.api.scheduling.Task;
import org.tailormap.api.scheduling.TaskType;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class FailingPocTask
extends QuartzJobBean
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String description;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        try {
            long workingTime = (long)(Math.random() * 10000.0);
            logger.debug("Working for {} ms", (Object)workingTime);
            Thread.sleep(workingTime);
            throw new UnsupportedOperationException("Failing POC task failed.");
        }
        catch (Exception e) {
            logger.error("Failing POC task failed.", (Throwable)e);
            jobDataMap.put("lastResult", "POC task executed unsuccessfully");
            context.setResult((Object)"POC task executed unsuccessfully");
            throw new JobExecutionException((Throwable)e);
        }
    }

    @Override
    public TaskType getType() {
        return TaskType.FAILINGPOC;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

