/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.tailormap.api.admin.model.TaskProgressEvent;
import org.tailormap.api.scheduling.Task;
import org.tailormap.api.scheduling.TaskType;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class InterruptablePocTask
extends QuartzJobBean
implements Task,
InterruptableJob {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean interrupted = false;
    private String description;

    public void interrupt() {
        logger.info("Interrupting POC task");
        this.interrupted = true;
    }

    protected void executeInternal(@NonNull JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        logger.debug("executing POC task {}:{}, details: {}", new Object[]{jobDetail.getKey().getGroup(), jobDetail.getKey().getName(), mergedJobDataMap.getWrappedMap()});
        TaskProgressEvent progressEvent = new TaskProgressEvent().startedAt(OffsetDateTime.now(ZoneId.systemDefault())).type(this.getType().getValue()).taskData(Map.of("jobKey", jobDetail.getKey().getName())).uuid(UUID.fromString(jobDetail.getKey().getName()));
        try {
            for (int i = 0; i < 110; i += 10) {
                long workingTime = (long)(Math.random() * 5000.0);
                logger.debug("Working for {} ms", (Object)workingTime);
                Thread.sleep(workingTime);
                logger.debug("Interruptable POC task is at {}%", (Object)i);
                context.setResult((Object)"Interruptable POC task is at %d%%".formatted(i));
                this.taskProgress(progressEvent.progress(i).total(100));
                if (this.interrupted) {
                    logger.debug("Interruptable POC task interrupted at {}%", (Object)Instant.now());
                    jobDataMap.put("lastResult", "Interruptable POC task interrupted after %d%% iterations".formatted(i));
                    jobDataMap.put("lastExecutionFinished", null);
                    context.setResult((Object)"Interruptable POC task interrupted after %d%% iterations".formatted(i));
                    return;
                }
                if (i != 30) continue;
                this.interrupt();
            }
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted", (Throwable)e);
        }
        jobDataMap.put("executionCount", 1 + (Integer)mergedJobDataMap.getOrDefault((Object)"executionCount", (Object)0));
        jobDataMap.put("lastExecutionFinished", (Object)Instant.now());
        jobDataMap.put("lastResult", "Interruptable POC task executed successfully");
        context.setResult((Object)"Interruptable POC task executed successfully");
    }

    @Override
    public TaskType getType() {
        return TaskType.INTERRUPTABLEPOC;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

