/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Trigger;
import org.springframework.util.Assert;

public class TMJobDataMap
extends HashMap<String, Object> {
    public TMJobDataMap(Map<String, Object> map) {
        this(String.valueOf(map.get("type")), (String)map.get("description"));
        this.putAll(map);
        if (map.containsKey("priority")) {
            this.setPriority((Integer)map.getOrDefault("priority", 5));
        } else {
            this.setPriority(5);
        }
    }

    public TMJobDataMap(@NotNull String type, @NotNull String description) {
        this(type, description, Trigger.TriggerState.NONE);
    }

    public TMJobDataMap(@NotNull String type, @NotNull String description, @NotNull Trigger.TriggerState state) {
        this(type, description, state, 5);
    }

    public TMJobDataMap(@NotNull String type, @NotNull String description, @NotNull Trigger.TriggerState state, int priority) {
        Assert.notNull((Object)type, (String)"type must not be null");
        Assert.doesNotContain((String)type, (String)"null", (String)"type must not be null");
        Assert.notNull((Object)description, (String)"description must not be null");
        Assert.notNull((Object)state, (String)"state must not be null");
        super.put("type", type);
        super.put("description", description);
        super.put("state", state);
        this.setPriority(priority);
    }

    @NotNull
    public String getType() {
        return super.get("type").toString();
    }

    @NotNull
    public String getDescription() {
        return super.get("description").toString();
    }

    @NotNull
    public Trigger.TriggerState getState() {
        return (Trigger.TriggerState)super.get("state");
    }

    public void setState(Trigger.TriggerState state) {
        if (null == state) {
            state = Trigger.TriggerState.NONE;
        }
        super.put("state", state);
    }

    public void setPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        }
        super.put("priority", priority);
    }

    public int getPriority() {
        return (Integer)super.get("priority");
    }
}

