/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Objects;
import org.tailormap.api.persistence.json.TMAttributeType;

@Schema(name="ColumnMetadata", description="presentation metadata for a feature")
public class ColumnMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String key;
    private String alias = null;
    private TMAttributeType type;

    public ColumnMetadata key(String key) {
        this.key = key;
        return this;
    }

    @Schema(name="key", description="Name of the attribute.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ColumnMetadata alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Schema(name="alias", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public ColumnMetadata type(TMAttributeType type) {
        this.type = type;
        return this;
    }

    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TMAttributeType getType() {
        return this.type;
    }

    public void setType(TMAttributeType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnMetadata columnMetadata = (ColumnMetadata)o;
        return Objects.equals(this.key, columnMetadata.key) && Objects.equals(this.alias, columnMetadata.alias) && Objects.equals(this.type, columnMetadata.type);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.alias, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnMetadata {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

