/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.viewer.model.CheckboxFilterConfigurationAttributeValuesSettingsInner;

@Schema(name="Filter_editConfiguration", description="configuration for editing filter")
@JsonTypeName(value="Filter_editConfiguration")
public class FilterEditConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FilterToolEnum filterTool;
    private Double minimumValue;
    private Double maximumValue;
    private Double initialValue;
    private Double initialLowerValue;
    private Double initialUpperValue;
    @Valid
    private @Valid List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings = new ArrayList<CheckboxFilterConfigurationAttributeValuesSettingsInner>();

    public FilterEditConfiguration filterTool(FilterToolEnum filterTool) {
        this.filterTool = filterTool;
        return this;
    }

    @Schema(name="filterTool", description="the type of filter tool", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filterTool")
    public FilterToolEnum getFilterTool() {
        return this.filterTool;
    }

    public void setFilterTool(FilterToolEnum filterTool) {
        this.filterTool = filterTool;
    }

    public FilterEditConfiguration minimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
        return this;
    }

    @Schema(name="minimumValue", description="minimum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minimumValue")
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public FilterEditConfiguration maximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
        return this;
    }

    @Schema(name="maximumValue", description="maximum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maximumValue")
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public FilterEditConfiguration initialValue(Double initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Schema(name="initialValue", description="initial value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialValue")
    public Double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Double initialValue) {
        this.initialValue = initialValue;
    }

    public FilterEditConfiguration initialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
        return this;
    }

    @Schema(name="initialLowerValue", description="initial lower value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerValue")
    public Double getInitialLowerValue() {
        return this.initialLowerValue;
    }

    public void setInitialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
    }

    public FilterEditConfiguration initialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
        return this;
    }

    @Schema(name="initialUpperValue", description="initial upper value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperValue")
    public Double getInitialUpperValue() {
        return this.initialUpperValue;
    }

    public void setInitialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
    }

    public FilterEditConfiguration attributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
        this.attributeValuesSettings = attributeValuesSettings;
        return this;
    }

    public FilterEditConfiguration addAttributeValuesSettingsItem(CheckboxFilterConfigurationAttributeValuesSettingsInner attributeValuesSettingsItem) {
        if (this.attributeValuesSettings == null) {
            this.attributeValuesSettings = new ArrayList<CheckboxFilterConfigurationAttributeValuesSettingsInner>();
        }
        this.attributeValuesSettings.add(attributeValuesSettingsItem);
        return this;
    }

    @Valid
    @Schema(name="attributeValuesSettings", description="settings for the attribute values", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attributeValuesSettings")
    public @Valid List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> getAttributeValuesSettings() {
        return this.attributeValuesSettings;
    }

    public void setAttributeValuesSettings(List<@Valid CheckboxFilterConfigurationAttributeValuesSettingsInner> attributeValuesSettings) {
        this.attributeValuesSettings = attributeValuesSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterEditConfiguration filterEditConfiguration = (FilterEditConfiguration)o;
        return Objects.equals((Object)this.filterTool, (Object)filterEditConfiguration.filterTool) && Objects.equals(this.minimumValue, filterEditConfiguration.minimumValue) && Objects.equals(this.maximumValue, filterEditConfiguration.maximumValue) && Objects.equals(this.initialValue, filterEditConfiguration.initialValue) && Objects.equals(this.initialLowerValue, filterEditConfiguration.initialLowerValue) && Objects.equals(this.initialUpperValue, filterEditConfiguration.initialUpperValue) && Objects.equals(this.attributeValuesSettings, filterEditConfiguration.attributeValuesSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterTool, this.minimumValue, this.maximumValue, this.initialValue, this.initialLowerValue, this.initialUpperValue, this.attributeValuesSettings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterEditConfiguration {\n");
        sb.append("    filterTool: ").append(this.toIndentedString((Object)this.filterTool)).append("\n");
        sb.append("    minimumValue: ").append(this.toIndentedString(this.minimumValue)).append("\n");
        sb.append("    maximumValue: ").append(this.toIndentedString(this.maximumValue)).append("\n");
        sb.append("    initialValue: ").append(this.toIndentedString(this.initialValue)).append("\n");
        sb.append("    initialLowerValue: ").append(this.toIndentedString(this.initialLowerValue)).append("\n");
        sb.append("    initialUpperValue: ").append(this.toIndentedString(this.initialUpperValue)).append("\n");
        sb.append("    attributeValuesSettings: ").append(this.toIndentedString(this.attributeValuesSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FilterToolEnum {
        SLIDER("SLIDER"),
        CHECKBOX("CHECKBOX");

        private final String value;

        private FilterToolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterToolEnum fromValue(String value) {
            for (FilterToolEnum b : FilterToolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

