/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.viewer.model.ViewerMenuItem;
import org.tailormap.api.viewer.model.ViewerPageTile;

public class Page
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String type = null;
    private String name = null;
    private String title = null;
    private String content = null;
    private String className = null;
    @Valid
    private @Valid List<@Valid ViewerPageTile> tiles = new ArrayList<ViewerPageTile>();
    @Valid
    private @Valid List<@Valid ViewerMenuItem> menu = new ArrayList<ViewerMenuItem>();

    public Page id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Page type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="define the type of the page which can be used to switch between layouts for example", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Page name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="name of the page which will be used for the url", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Page title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="page title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Page content(String content) {
        this.content = content;
        return this;
    }

    @Schema(name="content", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Page className(String className) {
        this.className = className;
        return this;
    }

    @Schema(name="className", description="page body content", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="className")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Page tiles(List<@Valid ViewerPageTile> tiles) {
        this.tiles = tiles;
        return this;
    }

    public Page addTilesItem(ViewerPageTile tilesItem) {
        if (this.tiles == null) {
            this.tiles = new ArrayList<ViewerPageTile>();
        }
        this.tiles.add(tilesItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="tiles", description="list of tiles, tiles are used to link to applications or other pages", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tiles")
    public @Valid @Size(min=0) List<@Valid ViewerPageTile> getTiles() {
        return this.tiles;
    }

    public void setTiles(List<@Valid ViewerPageTile> tiles) {
        this.tiles = tiles;
    }

    public Page menu(List<@Valid ViewerMenuItem> menu) {
        this.menu = menu;
        return this;
    }

    public Page addMenuItem(ViewerMenuItem menuItem) {
        if (this.menu == null) {
            this.menu = new ArrayList<ViewerMenuItem>();
        }
        this.menu.add(menuItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="menu", description="list of menu items for this page", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="menu")
    public @Valid @Size(min=0) List<@Valid ViewerMenuItem> getMenu() {
        return this.menu;
    }

    public void setMenu(List<@Valid ViewerMenuItem> menu) {
        this.menu = menu;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.id, page.id) && Objects.equals(this.type, page.type) && Objects.equals(this.name, page.name) && Objects.equals(this.title, page.title) && Objects.equals(this.content, page.content) && Objects.equals(this.className, page.className) && Objects.equals(this.tiles, page.tiles) && Objects.equals(this.menu, page.menu);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.name, this.title, this.content, this.className, this.tiles, this.menu);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Page {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    tiles: ").append(this.toIndentedString(this.tiles)).append("\n");
        sb.append("    menu: ").append(this.toIndentedString(this.menu)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

