/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.ddl;

import jakarta.annotation.PostConstruct;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"tailormap-api.exit-after-creating-ddl"}, havingValue="true")
public class ExitAfterCreatingDDL {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ApplicationContext appContext;

    public ExitAfterCreatingDDL(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @PostConstruct
    public void exit() {
        logger.info("Created DDL, exiting Spring application");
        SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
        logger.info("Exiting JVM");
        System.exit(0);
    }
}

