/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.SolrException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.admin.model.SearchIndexSummary;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.repository.FeatureTypeRepository;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.scheduling.IndexTask;
import org.tailormap.api.scheduling.TMJobDataMap;
import org.tailormap.api.scheduling.TaskManagerService;
import org.tailormap.api.scheduling.TaskType;
import org.tailormap.api.solr.SolrHelper;
import org.tailormap.api.solr.SolrService;
import org.tailormap.api.viewer.model.ErrorResponse;

@RestController
public class SolrAdminController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureTypeRepository featureTypeRepository;
    private final SearchIndexRepository searchIndexRepository;
    private final SolrService solrService;
    private final Scheduler scheduler;
    private final TaskManagerService taskManagerService;
    @Value(value="${tailormap-api.solr-query-timeout-seconds:7}")
    private int solrQueryTimeout;

    public SolrAdminController(@Autowired FeatureTypeRepository featureTypeRepository, @Autowired SearchIndexRepository searchIndexRepository, @Autowired SolrService solrService, @Autowired Scheduler scheduler, @Autowired TaskManagerService taskManagerService) {
        this.featureTypeRepository = featureTypeRepository;
        this.searchIndexRepository = searchIndexRepository;
        this.solrService = solrService;
        this.scheduler = scheduler;
        this.taskManagerService = taskManagerService;
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity<?> handleException(ResponseStatusException ex) {
        return ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(ex.getReason() != null ? ex.getReason() : ex.getBody().getTitle()).code(Integer.valueOf(ex.getStatusCode().value())));
    }

    @Operation(summary="Ping Solr", description="Ping Solr to check if it is available")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Solr is available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"status\":\"OK\",\"timeElapsed\":1}"))}), @ApiResponse(responseCode="500", description="Solr is not available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @GetMapping(path={"${tailormap-api.admin.base-path}/index/ping"}, produces={"application/json"})
    public ResponseEntity<?> pingSolr() {
        ResponseEntity responseEntity;
        block8: {
            SolrClient solrClient = this.solrService.getSolrClientForSearching();
            try {
                SolrPingResponse ping = solrClient.ping();
                logger.info("Solr ping status {}", ping.getResponse().get("status"));
                responseEntity = ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().put("status", ping.getResponse().get("status").toString()).put("timeElapsed", ping.getElapsedTime()));
                if (solrClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (solrClient != null) {
                        try {
                            solrClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SolrServerException e) {
                    logger.error("Error pinging solr", e);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            }
            solrClient.close();
        }
        return responseEntity;
    }

    @Operation(summary="Create or update a feature type index", description="Create or update a feature type index for a layer, will erase existing index if present")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Index create or update request accepted", content={@Content(mediaType="application/json", schema=@Schema(example="{\"type\":\"index\", \"uuid\":\"6308d26e-fe1e-4268-bb28-20db2cd06914\",\"code\":202}"))}), @ApiResponse(responseCode="404", description="Layer does not have feature type", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Layer does not have feature type\",\"code\":404}"))}), @ApiResponse(responseCode="400", description="Indexing WFS feature types is not supported", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Layer does not have valid feature type for indexing\",\"code\":400}"))}), @ApiResponse(responseCode="500", description="Error while indexing", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Transactional
    @Timed(value="index_feature_type", description="time spent to index feature type")
    @PutMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    public ResponseEntity<?> index(@PathVariable Long searchIndexId) {
        UUID taskUuid;
        SearchIndex searchIndex = this.validateInputAndFindIndex(searchIndexId);
        if (searchIndex.getStatus() == SearchIndex.Status.INDEXING) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Indexing already in progress, check tasks overview before retrying");
        }
        boolean createNewIndex = null == searchIndex.getLastIndexed() || searchIndex.getStatus() == SearchIndex.Status.INITIAL;
        boolean hasSchedule = null != searchIndex.getSchedule() && null != searchIndex.getSchedule().getUuid();
        try {
            if (hasSchedule) {
                taskUuid = searchIndex.getSchedule().getUuid();
                this.startScheduledJobIndexing(searchIndex);
            } else {
                taskUuid = this.startOneTimeJobIndexing(searchIndex);
            }
            this.searchIndexRepository.save((Object)searchIndex);
        }
        catch (IOException | UnsupportedOperationException | SolrServerException | SolrException | SchedulerException e) {
            logger.error("Error indexing", e);
            searchIndex.setStatus(SearchIndex.Status.ERROR);
            this.searchIndexRepository.save((Object)searchIndex);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        logger.info("Scheduled {} index for search index {}", (Object)(createNewIndex ? "creation of a new" : "update of"), (Object)searchIndex.getName());
        return ResponseEntity.accepted().body(Map.of("code", 202, "type", TaskType.INDEX.getValue(), "uuid", taskUuid, "message", "Indexing scheduled"));
    }

    private UUID startOneTimeJobIndexing(SearchIndex searchIndex) throws SolrServerException, IOException, SchedulerException {
        UUID taskName = this.taskManagerService.createTask(IndexTask.class, new TMJobDataMap(Map.of("type", TaskType.INDEX, "description", "One-time indexing of " + searchIndex.getName(), "indexId", searchIndex.getId().toString(), "priority", 0)));
        logger.info("One-time indexing job with UUID {} started", (Object)taskName);
        return taskName;
    }

    private void startScheduledJobIndexing(SearchIndex searchIndex) throws SchedulerException {
        JobKey jobKey = this.taskManagerService.getJobKey(TaskType.INDEX, searchIndex.getSchedule().getUuid());
        if (null == jobKey) {
            throw new SchedulerException("Indexing job not found in scheduler");
        }
        this.scheduler.triggerJob(jobKey);
        logger.info("Indexing of scheduled job with UUID {} started", (Object)searchIndex.getSchedule().getUuid());
    }

    private SearchIndex validateInputAndFindIndex(Long searchIndexId) {
        this.pingSolr();
        SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById((Object)searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
        TMFeatureType indexingFT = (TMFeatureType)this.featureTypeRepository.findById((Object)searchIndex.getFeatureTypeId()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Feature type not found"));
        if (TMFeatureSource.Protocol.WFS.equals((Object)indexingFT.getFeatureSource().getProtocol())) {
            searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(new SearchIndexSummary().errorMessage("WFS indexing not supported"));
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Layer does not have valid feature type for indexing");
        }
        return searchIndex;
    }

    @Operation(summary="Clear index for a feature type", description="Clear index for the feature type")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Index cleared"), @ApiResponse(responseCode="404", description="Index not configured for feature type"), @ApiResponse(responseCode="500", description="Error while clearing index", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Timed(value="index_delete", description="time spent to delete an index of a feature type")
    @DeleteMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<?> clearIndex(@PathVariable Long searchIndexId) {
        try (SolrClient solrClient = this.solrService.getSolrClientForSearching();
             SolrHelper solrHelper = new SolrHelper(solrClient).withQueryTimeout(this.solrQueryTimeout);){
            solrHelper.clearIndexForLayer(searchIndexId);
            SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById((Object)searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
            searchIndex.setLastIndexed(null).setStatus(SearchIndex.Status.INITIAL).setSummary(new SearchIndexSummary().total(Integer.valueOf(0)));
            this.searchIndexRepository.save((Object)searchIndex);
        }
        catch (IOException | NoSuchElementException | SolrServerException e) {
            logger.warn("Error clearing index", e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
        logger.info("Index cleared for index {}", (Object)searchIndexId);
        return ResponseEntity.noContent().build();
    }
}

