/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.solr;

import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SolrService {
    @Value(value="${tailormap-api.solr-url}")
    private String solrUrl;
    @Value(value="${tailormap-api.solr-core-name:tailormap}")
    private String solrCoreName;
    @Value(value="${tailormap-api.solr-connection-timeout-seconds:60}")
    private int solrConnectionTimeout;
    @Value(value="${tailormap-api.solr-request-timeout-seconds:240}")
    private int solrRequestTimeout;
    @Value(value="${tailormap-api.solr-idle-timeout-seconds:10}")
    private int solrIdleTimeout;

    public SolrClient getSolrClientForIndexing() {
        return ((Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder(this.solrUrl + this.solrCoreName).withFollowRedirects(true)).withConnectionTimeout((long)this.solrConnectionTimeout, TimeUnit.SECONDS)).withRequestTimeout((long)this.solrRequestTimeout, TimeUnit.SECONDS)).withIdleTimeout((long)this.solrIdleTimeout, TimeUnit.SECONDS)).build();
    }

    public SolrClient getSolrClientForSearching() {
        return ((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder(this.solrUrl + this.solrCoreName).withConnectionTimeout((long)this.solrConnectionTimeout, TimeUnit.SECONDS)).withFollowRedirects(true)).build();
    }

    public void setSolrUrl(String solrUrl) {
        this.solrUrl = solrUrl;
    }
}

