package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.FormTab;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model with options for an form
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "FormOptions", description = "model with options for an form")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class FormOptions implements Serializable {

  private static final long serialVersionUID = 1L;

  private String description = null;

  private Integer columns;

  @Valid
  private List<@Valid FormTab> tabs = new ArrayList<>();

  public FormOptions description(String description) {
    this.description = description;
    return this;
  }

  /**
   * description text for the form
   * @return description
   */
  
  @Schema(name = "description", description = "description text for the form", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public FormOptions columns(Integer columns) {
    this.columns = columns;
    return this;
  }

  /**
   * the number of columns (adjusts the width of the form)
   * @return columns
   */
  
  @Schema(name = "columns", description = "the number of columns (adjusts the width of the form)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("columns")
  public Integer getColumns() {
    return columns;
  }

  public void setColumns(Integer columns) {
    this.columns = columns;
  }

  public FormOptions tabs(List<@Valid FormTab> tabs) {
    this.tabs = tabs;
    return this;
  }

  public FormOptions addTabsItem(FormTab tabsItem) {
    if (this.tabs == null) {
      this.tabs = new ArrayList<>();
    }
    this.tabs.add(tabsItem);
    return this;
  }

  /**
   * list of tabs for a form
   * @return tabs
   */
  @Valid 
  @Schema(name = "tabs", description = "list of tabs for a form", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tabs")
  public List<@Valid FormTab> getTabs() {
    return tabs;
  }

  public void setTabs(List<@Valid FormTab> tabs) {
    this.tabs = tabs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormOptions formOptions = (FormOptions) o;
    return Objects.equals(this.description, formOptions.description) &&
        Objects.equals(this.columns, formOptions.columns) &&
        Objects.equals(this.tabs, formOptions.tabs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, columns, tabs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormOptions {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    tabs: ").append(toIndentedString(tabs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

