package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.LayerSettings;
import org.tailormap.api.persistence.json.QuantizedMeshLayerSettings;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;
import org.tailormap.api.persistence.json.Tiles3dLayerSettings;
import org.tailormap.api.persistence.json.WMSLayerSettings;
import org.tailormap.api.persistence.json.WMTSLayerSettings;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Default settings for all layers of this service which can be overridden on a per-layer basis.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "GeoServiceDefaultLayerSettings", description = "Default settings for all layers of this service which can be overridden on a per-layer basis.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class GeoServiceDefaultLayerSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title = null;

  private Boolean hiDpiDisabled = null;

  private FeatureTypeRef featureType;

  private String attribution = null;

  private String description = null;

  private String legendImageId = null;

  @Valid
  private List<@Valid AuthorizationRule> authorizationRules = new ArrayList<>();

  private Boolean tilingDisabled = null;

  private Integer tilingGutter = null;

  private TileLayerHiDpiMode hiDpiMode;

  private String hiDpiSubstituteLayer = null;

  public GeoServiceDefaultLayerSettings() {
    super();
  }

  public GeoServiceDefaultLayerSettings title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Override default title, null if not overridden.
   * @return title
   */
  
  @Schema(name = "title", description = "Override default title, null if not overridden.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public GeoServiceDefaultLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
    return this;
  }

  /**
   * Get hiDpiDisabled
   * @return hiDpiDisabled
   */
  
  @Schema(name = "hiDpiDisabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiDisabled")
  public Boolean getHiDpiDisabled() {
    return hiDpiDisabled;
  }

  public void setHiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
  }

  public GeoServiceDefaultLayerSettings featureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
    return this;
  }

  /**
   * Get featureType
   * @return featureType
   */
  @Valid 
  @Schema(name = "featureType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("featureType")
  public FeatureTypeRef getFeatureType() {
    return featureType;
  }

  public void setFeatureType(FeatureTypeRef featureType) {
    this.featureType = featureType;
  }

  public GeoServiceDefaultLayerSettings attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution to show for this layer.
   * @return attribution
   */
  
  @Schema(name = "attribution", description = "Attribution to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public GeoServiceDefaultLayerSettings description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description to show for this layer.
   * @return description
   */
  
  @Schema(name = "description", description = "Description to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public GeoServiceDefaultLayerSettings legendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
    return this;
  }

  /**
   * ID of uploaded legend image
   * @return legendImageId
   */
  
  @Schema(name = "legendImageId", description = "ID of uploaded legend image", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendImageId")
  public String getLegendImageId() {
    return legendImageId;
  }

  public void setLegendImageId(String legendImageId) {
    this.legendImageId = legendImageId;
  }

  public GeoServiceDefaultLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
    return this;
  }

  public GeoServiceDefaultLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
    if (this.authorizationRules == null) {
      this.authorizationRules = new ArrayList<>();
    }
    this.authorizationRules.add(authorizationRulesItem);
    return this;
  }

  /**
   * Get authorizationRules
   * @return authorizationRules
   */
  @Valid 
  @Schema(name = "authorizationRules", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("authorizationRules")
  public List<@Valid AuthorizationRule> getAuthorizationRules() {
    return authorizationRules;
  }

  public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
    this.authorizationRules = authorizationRules;
  }

  public GeoServiceDefaultLayerSettings tilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
    return this;
  }

  /**
   * Get tilingDisabled
   * @return tilingDisabled
   */
  @NotNull 
  @Schema(name = "tilingDisabled", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("tilingDisabled")
  public Boolean getTilingDisabled() {
    return tilingDisabled;
  }

  public void setTilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
  }

  public GeoServiceDefaultLayerSettings tilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
    return this;
  }

  /**
   * Get tilingGutter
   * @return tilingGutter
   */
  @NotNull 
  @Schema(name = "tilingGutter", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("tilingGutter")
  public Integer getTilingGutter() {
    return tilingGutter;
  }

  public void setTilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
  }

  public GeoServiceDefaultLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
    return this;
  }

  /**
   * Get hiDpiMode
   * @return hiDpiMode
   */
  @Valid 
  @Schema(name = "hiDpiMode", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiMode")
  public TileLayerHiDpiMode getHiDpiMode() {
    return hiDpiMode;
  }

  public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
  }

  public GeoServiceDefaultLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    return this;
  }

  /**
   * Layer name of this service to substitute when rendering at high dpi.
   * @return hiDpiSubstituteLayer
   */
  
  @Schema(name = "hiDpiSubstituteLayer", description = "Layer name of this service to substitute when rendering at high dpi.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiSubstituteLayer")
  public String getHiDpiSubstituteLayer() {
    return hiDpiSubstituteLayer;
  }

  public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoServiceDefaultLayerSettings geoServiceDefaultLayerSettings = (GeoServiceDefaultLayerSettings) o;
    return Objects.equals(this.title, geoServiceDefaultLayerSettings.title) &&
        Objects.equals(this.hiDpiDisabled, geoServiceDefaultLayerSettings.hiDpiDisabled) &&
        Objects.equals(this.featureType, geoServiceDefaultLayerSettings.featureType) &&
        Objects.equals(this.attribution, geoServiceDefaultLayerSettings.attribution) &&
        Objects.equals(this.description, geoServiceDefaultLayerSettings.description) &&
        Objects.equals(this.legendImageId, geoServiceDefaultLayerSettings.legendImageId) &&
        Objects.equals(this.authorizationRules, geoServiceDefaultLayerSettings.authorizationRules) &&
        Objects.equals(this.tilingDisabled, geoServiceDefaultLayerSettings.tilingDisabled) &&
        Objects.equals(this.tilingGutter, geoServiceDefaultLayerSettings.tilingGutter) &&
        Objects.equals(this.hiDpiMode, geoServiceDefaultLayerSettings.hiDpiMode) &&
        Objects.equals(this.hiDpiSubstituteLayer, geoServiceDefaultLayerSettings.hiDpiSubstituteLayer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, hiDpiDisabled, featureType, attribution, description, legendImageId, authorizationRules, tilingDisabled, tilingGutter, hiDpiMode, hiDpiSubstituteLayer);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoServiceDefaultLayerSettings {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    hiDpiDisabled: ").append(toIndentedString(hiDpiDisabled)).append("\n");
    sb.append("    featureType: ").append(toIndentedString(featureType)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    legendImageId: ").append(toIndentedString(legendImageId)).append("\n");
    sb.append("    authorizationRules: ").append(toIndentedString(authorizationRules)).append("\n");
    sb.append("    tilingDisabled: ").append(toIndentedString(tilingDisabled)).append("\n");
    sb.append("    tilingGutter: ").append(toIndentedString(tilingGutter)).append("\n");
    sb.append("    hiDpiMode: ").append(toIndentedString(hiDpiMode)).append("\n");
    sb.append("    hiDpiSubstituteLayer: ").append(toIndentedString(hiDpiSubstituteLayer)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

