package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * LayerExportCapabilities
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class LayerExportCapabilities implements Serializable {

  private static final long serialVersionUID = 1L;

  private Boolean exportable;

  @Valid
  private List<String> outputFormats = new ArrayList<>();

  public LayerExportCapabilities() {
    super();
  }

  public LayerExportCapabilities exportable(Boolean exportable) {
    this.exportable = exportable;
    return this;
  }

  /**
   * Get exportable
   * @return exportable
   */
  @NotNull 
  @Schema(name = "exportable", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("exportable")
  public Boolean getExportable() {
    return exportable;
  }

  public void setExportable(Boolean exportable) {
    this.exportable = exportable;
  }

  public LayerExportCapabilities outputFormats(List<String> outputFormats) {
    this.outputFormats = outputFormats;
    return this;
  }

  public LayerExportCapabilities addOutputFormatsItem(String outputFormatsItem) {
    if (this.outputFormats == null) {
      this.outputFormats = new ArrayList<>();
    }
    this.outputFormats.add(outputFormatsItem);
    return this;
  }

  /**
   * Get outputFormats
   * @return outputFormats
   */
  
  @Schema(name = "outputFormats", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("outputFormats")
  public List<String> getOutputFormats() {
    return outputFormats;
  }

  public void setOutputFormats(List<String> outputFormats) {
    this.outputFormats = outputFormats;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LayerExportCapabilities layerExportCapabilities = (LayerExportCapabilities) o;
    return Objects.equals(this.exportable, layerExportCapabilities.exportable) &&
        Objects.equals(this.outputFormats, layerExportCapabilities.outputFormats);
  }

  @Override
  public int hashCode() {
    return Objects.hash(exportable, outputFormats);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LayerExportCapabilities {\n");
    sb.append("    exportable: ").append(toIndentedString(exportable)).append("\n");
    sb.append("    outputFormats: ").append(toIndentedString(outputFormats)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

