package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Configuration for a boolean filter
 */

@Schema(name = "SwitchFilterConfiguration", description = "Configuration for a boolean filter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class SwitchFilterConfiguration implements Serializable {

  private static final long serialVersionUID = 1L;

  private String value1;

  private String value2;

  private String alias1;

  private String alias2;

  private Boolean startWithValue2 = false;

  public SwitchFilterConfiguration value1(String value1) {
    this.value1 = value1;
    return this;
  }

  /**
   * Get value1
   * @return value1
   */
  
  @Schema(name = "value1", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value1")
  public String getValue1() {
    return value1;
  }

  public void setValue1(String value1) {
    this.value1 = value1;
  }

  public SwitchFilterConfiguration value2(String value2) {
    this.value2 = value2;
    return this;
  }

  /**
   * Get value2
   * @return value2
   */
  
  @Schema(name = "value2", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("value2")
  public String getValue2() {
    return value2;
  }

  public void setValue2(String value2) {
    this.value2 = value2;
  }

  public SwitchFilterConfiguration alias1(String alias1) {
    this.alias1 = alias1;
    return this;
  }

  /**
   * Get alias1
   * @return alias1
   */
  
  @Schema(name = "alias1", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias1")
  public String getAlias1() {
    return alias1;
  }

  public void setAlias1(String alias1) {
    this.alias1 = alias1;
  }

  public SwitchFilterConfiguration alias2(String alias2) {
    this.alias2 = alias2;
    return this;
  }

  /**
   * Get alias2
   * @return alias2
   */
  
  @Schema(name = "alias2", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("alias2")
  public String getAlias2() {
    return alias2;
  }

  public void setAlias2(String alias2) {
    this.alias2 = alias2;
  }

  public SwitchFilterConfiguration startWithValue2(Boolean startWithValue2) {
    this.startWithValue2 = startWithValue2;
    return this;
  }

  /**
   * when true the filter starts with value2 selected
   * @return startWithValue2
   */
  
  @Schema(name = "startWithValue2", description = "when true the filter starts with value2 selected", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startWithValue2")
  public Boolean getStartWithValue2() {
    return startWithValue2;
  }

  public void setStartWithValue2(Boolean startWithValue2) {
    this.startWithValue2 = startWithValue2;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SwitchFilterConfiguration switchFilterConfiguration = (SwitchFilterConfiguration) o;
    return Objects.equals(this.value1, switchFilterConfiguration.value1) &&
        Objects.equals(this.value2, switchFilterConfiguration.value2) &&
        Objects.equals(this.alias1, switchFilterConfiguration.alias1) &&
        Objects.equals(this.alias2, switchFilterConfiguration.alias2) &&
        Objects.equals(this.startWithValue2, switchFilterConfiguration.startWithValue2);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value1, value2, alias1, alias2, startWithValue2);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SwitchFilterConfiguration {\n");
    sb.append("    value1: ").append(toIndentedString(value1)).append("\n");
    sb.append("    value2: ").append(toIndentedString(value2)).append("\n");
    sb.append("    alias1: ").append(toIndentedString(alias1)).append("\n");
    sb.append("    alias2: ").append(toIndentedString(alias2)).append("\n");
    sb.append("    startWithValue2: ").append(toIndentedString(startWithValue2)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

