package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A -possibly empty- list of unique values of the requested attributes.
 */

@Schema(name = "UniqueValuesResponse", description = "A -possibly empty- list of unique values of the requested attributes.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.13.0")
public class UniqueValuesResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Boolean filterApplied = false;

  @Valid
  private Set<Object> values = new LinkedHashSet<>();

  public UniqueValuesResponse() {
    super();
  }

  public UniqueValuesResponse filterApplied(Boolean filterApplied) {
    this.filterApplied = filterApplied;
    return this;
  }

  /**
   * true if the filter was applied, false otherwise
   * @return filterApplied
   */
  
  @Schema(name = "filterApplied", description = "true if the filter was applied, false otherwise", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filterApplied")
  public Boolean getFilterApplied() {
    return filterApplied;
  }

  public void setFilterApplied(Boolean filterApplied) {
    this.filterApplied = filterApplied;
  }

  public UniqueValuesResponse values(Set<Object> values) {
    this.values = values;
    return this;
  }

  public UniqueValuesResponse addValuesItem(Object valuesItem) {
    if (this.values == null) {
      this.values = new LinkedHashSet<>();
    }
    this.values.add(valuesItem);
    return this;
  }

  /**
   * list of unique values
   * @return values
   */
  @NotNull @Size(min = 0) 
  @Schema(name = "values", description = "list of unique values", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("values")
  public Set<Object> getValues() {
    return values;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setValues(Set<Object> values) {
    this.values = values;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UniqueValuesResponse uniqueValuesResponse = (UniqueValuesResponse) o;
    return Objects.equals(this.filterApplied, uniqueValuesResponse.filterApplied) &&
        Objects.equals(this.values, uniqueValuesResponse.values);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filterApplied, values);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UniqueValuesResponse {\n");
    sb.append("    filterApplied: ").append(toIndentedString(filterApplied)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

