/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.ddl;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
@ConditionalOnProperty(name={"spring.jpa.properties.javax.persistence.schema-generation.scripts.delete-first"}, havingValue="true")
public class DeleteDDLScriptBeforeCreating {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${spring.jpa.properties.javax.persistence.schema-generation.scripts.create-target}")
    private String target;
    private String url;
    private String username;
    private String password;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Bean
    public DataSource getDataSource() {
        return DataSourceBuilder.create().url(this.url).username(this.username).password(this.password).build();
    }

    @PostConstruct
    public void delete() throws IOException {
        if (this.target != null) {
            Path path = Path.of(this.target, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0]) && Files.deleteIfExists(path)) {
                logger.debug("Deleted DDL target file {}", (Object)path.toAbsolutePath());
            } else {
                logger.info("Could not delete DDL target file {}", (Object)path.toAbsolutePath());
            }
        }
    }
}

