/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Entity
@EntityListeners(value={EntityEventPublisher.class})
@EnhancementInfo(version="6.6.22.Final")
public class Upload
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    public static final String CATEGORY_APP_LOGO = "app-logo";
    public static final String CATEGORY_LEGEND = "legend";
    public static final String CATEGORY_PORTAL_IMAGE = "portal-image";
    public static final String CATEGORY_DRAWING_STYLE = "drawing-style";
    public static final String CATEGORY_DRAWING_STYLE_IMAGE = "drawing-style-image";
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    UUID id;
    String category;
    String filename;
    String mimeType;
    Integer imageWidth;
    Integer imageHeight;
    Boolean hiDpiImage;
    @NotNull
    OffsetDateTime lastModified;
    @Basic(fetch=FetchType.LAZY)
    byte[] content;
    String hash;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public Upload() {
        this.$$_hibernate_write_lastModified(OffsetDateTime.now(ZoneId.systemDefault()));
    }

    public int getContentLength() {
        return this.getContent() == null ? 0 : this.$$_hibernate_read_content().length;
    }

    public UUID getId() {
        return this.$$_hibernate_read_id();
    }

    public Upload setId(UUID id) {
        this.$$_hibernate_write_id(id);
        return this;
    }

    public String getCategory() {
        return this.$$_hibernate_read_category();
    }

    public Upload setCategory(String category) {
        this.$$_hibernate_write_category(category);
        return this;
    }

    public String getFilename() {
        return this.$$_hibernate_read_filename();
    }

    public Upload setFilename(String filename) {
        this.$$_hibernate_write_filename(filename);
        return this;
    }

    public String getMimeType() {
        return this.$$_hibernate_read_mimeType();
    }

    public Upload setMimeType(String mimeType) {
        this.$$_hibernate_write_mimeType(mimeType);
        return this;
    }

    public Integer getImageWidth() {
        return this.$$_hibernate_read_imageWidth();
    }

    public Upload setImageWidth(Integer imageWidth) {
        this.$$_hibernate_write_imageWidth(imageWidth);
        return this;
    }

    public Integer getImageHeight() {
        return this.$$_hibernate_read_imageHeight();
    }

    public Upload setImageHeight(Integer imageHeight) {
        this.$$_hibernate_write_imageHeight(imageHeight);
        return this;
    }

    public Boolean getHiDpiImage() {
        return this.$$_hibernate_read_hiDpiImage();
    }

    public Upload setHiDpiImage(Boolean hiDpiImage) {
        this.$$_hibernate_write_hiDpiImage(hiDpiImage);
        return this;
    }

    public OffsetDateTime getLastModified() {
        return this.$$_hibernate_read_lastModified();
    }

    public Upload setLastModified(OffsetDateTime lastModified) {
        this.$$_hibernate_write_lastModified(lastModified);
        return this;
    }

    public byte[] getContent() {
        return this.$$_hibernate_read_content();
    }

    public Upload setContent(byte[] content) {
        this.$$_hibernate_write_content(content);
        return this;
    }

    public String getHash() {
        return this.$$_hibernate_read_hash();
    }

    public Upload setHash(String hash) {
        this.$$_hibernate_write_hash(hash);
        return this;
    }

    @PrePersist
    @PreUpdate
    public void computeHash() {
        if (this.$$_hibernate_read_content() != null) {
            this.$$_hibernate_write_hash(DigestUtils.sha1Hex((byte[])this.$$_hibernate_read_content()));
        } else {
            this.$$_hibernate_write_hash(null);
        }
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Upload upload = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        Upload upload = this;
        upload = null;
        upload = NoopCollectionTracker.INSTANCE;
        return upload;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public String $$_hibernate_read_category() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.category = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "category", (Object)this.category);
        }
        return this.category;
    }

    public void $$_hibernate_write_category(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"category", (Object)string, (Object)this.category)) {
            this.$$_hibernate_trackChange("category");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.category = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "category", (Object)this.category, (Object)string);
            return;
        }
        this.category = string;
    }

    public String $$_hibernate_read_filename() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.filename = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "filename", (Object)this.filename);
        }
        return this.filename;
    }

    public void $$_hibernate_write_filename(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"filename", (Object)string, (Object)this.filename)) {
            this.$$_hibernate_trackChange("filename");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.filename = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "filename", (Object)this.filename, (Object)string);
            return;
        }
        this.filename = string;
    }

    public String $$_hibernate_read_mimeType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.mimeType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "mimeType", (Object)this.mimeType);
        }
        return this.mimeType;
    }

    public void $$_hibernate_write_mimeType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"mimeType", (Object)string, (Object)this.mimeType)) {
            this.$$_hibernate_trackChange("mimeType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.mimeType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "mimeType", (Object)this.mimeType, (Object)string);
            return;
        }
        this.mimeType = string;
    }

    public Integer $$_hibernate_read_imageWidth() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.imageWidth = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "imageWidth", (Object)this.imageWidth);
        }
        return this.imageWidth;
    }

    public void $$_hibernate_write_imageWidth(Integer n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"imageWidth", (Object)n, (Object)this.imageWidth)) {
            this.$$_hibernate_trackChange("imageWidth");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.imageWidth = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "imageWidth", (Object)this.imageWidth, (Object)n);
            return;
        }
        this.imageWidth = n;
    }

    public Integer $$_hibernate_read_imageHeight() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.imageHeight = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "imageHeight", (Object)this.imageHeight);
        }
        return this.imageHeight;
    }

    public void $$_hibernate_write_imageHeight(Integer n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"imageHeight", (Object)n, (Object)this.imageHeight)) {
            this.$$_hibernate_trackChange("imageHeight");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.imageHeight = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "imageHeight", (Object)this.imageHeight, (Object)n);
            return;
        }
        this.imageHeight = n;
    }

    public Boolean $$_hibernate_read_hiDpiImage() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.hiDpiImage = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "hiDpiImage", (Object)this.hiDpiImage);
        }
        return this.hiDpiImage;
    }

    public void $$_hibernate_write_hiDpiImage(Boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"hiDpiImage", (Object)bl, (Object)this.hiDpiImage)) {
            this.$$_hibernate_trackChange("hiDpiImage");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.hiDpiImage = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "hiDpiImage", (Object)this.hiDpiImage, (Object)bl);
            return;
        }
        this.hiDpiImage = bl;
    }

    public OffsetDateTime $$_hibernate_read_lastModified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (OffsetDateTime)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModified", (Object)this.lastModified);
        }
        return this.lastModified;
    }

    public void $$_hibernate_write_lastModified(OffsetDateTime offsetDateTime) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModified", (Object)offsetDateTime, (Object)this.lastModified)) {
            this.$$_hibernate_trackChange("lastModified");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (OffsetDateTime)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModified", (Object)this.lastModified, (Object)offsetDateTime);
            return;
        }
        this.lastModified = offsetDateTime;
    }

    public byte[] $$_hibernate_read_content() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.content = (byte[])this.$$_hibernate_getInterceptor().readObject((Object)this, "content", (Object)this.content);
        }
        return this.content;
    }

    public void $$_hibernate_write_content(byte[] byArray) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"content", (Object)byArray, (Object)this.content)) {
            this.$$_hibernate_trackChange("content");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.content = (byte[])this.$$_hibernate_getInterceptor().writeObject((Object)this, "content", (Object)this.content, (Object)byArray);
            return;
        }
        this.content = byArray;
    }

    public String $$_hibernate_read_hash() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.hash = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "hash", (Object)this.hash);
        }
        return this.hash;
    }

    public void $$_hibernate_write_hash(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"hash", (Object)string, (Object)this.hash)) {
            this.$$_hibernate_trackChange("hash");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.hash = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "hash", (Object)this.hash, (Object)string);
            return;
        }
        this.hash = string;
    }
}

