/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.helper;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.viewer.model.UniqueValuesResponse;

public class UniqueValuesHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniqueValuesResponse getUniqueValues(TMFeatureType tmft, String attributeName, String filter, FilterFactory ff, FeatureSourceFactoryHelper featureSourceFactoryHelper, Boolean useGeotoolsUniqueFunction) {
        UniqueValuesResponse uniqueValuesResponse = new UniqueValuesResponse().filterApplied(Boolean.valueOf(false));
        SimpleFeatureSource fs = null;
        try {
            Not notNull;
            Filter existingFilter = null;
            if (null != filter) {
                existingFilter = ECQL.toFilter((String)filter);
            }
            logger.trace("existingFilter: {}", (Object)existingFilter);
            Not f = notNull = ff.not((Filter)ff.isNull((Expression)ff.property(attributeName)));
            if (null != existingFilter) {
                f = ff.and((Filter)notNull, existingFilter);
                uniqueValuesResponse.filterApplied(Boolean.valueOf(true));
            }
            Query q = new Query(tmft.getName(), (Filter)f);
            q.setPropertyNames(new String[]{attributeName});
            q.setSortBy(new SortBy[]{ff.sort(attributeName, SortOrder.ASCENDING)});
            logger.trace("Unique values query: {}", (Object)q);
            fs = featureSourceFactoryHelper.openGeoToolsFeatureSource(tmft);
            if (!useGeotoolsUniqueFunction.booleanValue()) {
                logger.trace("Using feature visitor to get unique values");
                fs.getFeatures(q).accepts(feature -> uniqueValuesResponse.addValuesItem(feature.getProperty(attributeName).getValue()), null);
            } else {
                logger.trace("Using geotools unique collection function to get unique values");
                Function unique = ff.function("Collection_Unique", new Expression[]{ff.property(attributeName)});
                Object o = unique.evaluate((Object)fs.getFeatures(q));
                if (o instanceof Set) {
                    Set uniqueValues = (Set)o;
                    uniqueValuesResponse.setValues(new TreeSet(uniqueValues));
                }
            }
        }
        catch (CQLException e) {
            logger.error("Could not parse requested filter", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Could not parse requested filter");
        }
        catch (IOException e) {
            logger.error("Could not retrieve attribute data", (Throwable)e);
        }
        finally {
            if (fs != null) {
                fs.getDataStore().dispose();
            }
        }
        return uniqueValuesResponse;
    }
}

